/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem;

import com.day.cq.wcm.api.Template;
import com.day.cq.wcm.api.policies.ContentPolicy;
import com.day.cq.wcm.api.policies.ContentPolicyMapping;
import io.wcm.testing.mock.aem.MockContentPolicy;
import java.util.Calendar;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;

class MockContentPolicyMapping
implements ContentPolicyMapping {
    private final Resource resource;
    private final ResourceResolver resourceResolver;

    MockContentPolicyMapping(@NotNull Resource resource) {
        this.resource = resource;
        this.resourceResolver = resource.getResourceResolver();
    }

    public String getPath() {
        return this.resource.getPath();
    }

    public ContentPolicy getPolicy() {
        String policyPath;
        Resource policyResource;
        String policyRelativePath = (String)this.resource.getValueMap().get("cq:policy", String.class);
        if (StringUtils.isNotBlank((CharSequence)policyRelativePath) && (policyResource = this.resourceResolver.getResource(policyPath = "/conf/$aem-mock$/settings/wcm/policies/" + policyRelativePath)) != null) {
            return new MockContentPolicy(policyResource);
        }
        return null;
    }

    public String getName() {
        return this.resource.getName();
    }

    public Calendar getLastModified() {
        return (Calendar)this.resource.getValueMap().get("jcr:lastModified", Calendar.class);
    }

    public Template getTemplate() {
        throw new UnsupportedOperationException();
    }
}

