/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem;

import com.adobe.cq.dam.cfm.ContentElement;
import com.adobe.cq.dam.cfm.ContentFragmentException;
import com.adobe.cq.dam.cfm.ContentVariation;
import com.adobe.cq.dam.cfm.FragmentData;
import com.adobe.cq.dam.cfm.VariationDef;
import com.adobe.cq.dam.cfm.VariationTemplate;
import com.adobe.cq.dam.cfm.VersionDef;
import com.adobe.cq.dam.cfm.VersionedContent;
import io.wcm.testing.mock.aem.MockContentFragment;
import io.wcm.testing.mock.aem.MockContentFragment_ContentVariation_Structured;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MockContentFragment_ContentElement_Structured
implements ContentElement {
    private final MockContentFragment contentFragment;
    private final String structuredDataKey;
    private final ModifiableValueMap structuredDataProps;

    MockContentFragment_ContentElement_Structured(MockContentFragment contentFragment, String structuredDataKey, ModifiableValueMap structuredDataProps) {
        this.contentFragment = contentFragment;
        this.structuredDataKey = structuredDataKey;
        this.structuredDataProps = structuredDataProps;
    }

    @Nullable
    public <AdapterType> AdapterType adaptTo(@NotNull Class<AdapterType> type) {
        return this.contentFragment.adaptTo(type);
    }

    public String getName() {
        return this.structuredDataKey;
    }

    public String getTitle() {
        return this.structuredDataKey;
    }

    public String getContent() {
        return MockContentFragment_ContentElement_Structured.getContent(this.structuredDataKey, this.structuredDataProps);
    }

    public void setContent(String content, String contentType) throws ContentFragmentException {
        MockContentFragment_ContentElement_Structured.setContent(this.structuredDataKey, this.structuredDataProps, content);
    }

    static String getContent(String structuredDataKey, ModifiableValueMap structuredDataProps) {
        StringBuilder result = new StringBuilder();
        Object value = structuredDataProps.get((Object)structuredDataKey);
        if (value != null) {
            if (value.getClass().isArray()) {
                int length = Array.getLength(value);
                boolean first = true;
                for (int i = 0; i < length; ++i) {
                    if (first) {
                        first = false;
                    } else {
                        result.append("\n");
                    }
                    result.append(Array.get(value, i).toString());
                }
            } else {
                result.append(value.toString());
            }
        }
        return result.toString();
    }

    static void setContent(String structuredDataKey, ModifiableValueMap structuredDataProps, String content) {
        structuredDataProps.put((Object)structuredDataKey, (Object)content);
    }

    public String getContentType() {
        return null;
    }

    public ContentVariation createVariation(VariationTemplate template) throws ContentFragmentException {
        VariationDef variationDef = (VariationDef)template;
        return new MockContentFragment_ContentVariation_Structured(variationDef, this.structuredDataKey, this.getVariationStrucuturedDataProps(template.getName()));
    }

    public ContentVariation getVariation(String variationName) {
        return this.getVariationsStream().filter(variation -> StringUtils.equals((CharSequence)variation.getName(), (CharSequence)variationName)).findFirst().orElse(null);
    }

    public Iterator<ContentVariation> getVariations() {
        return this.getVariationsStream().iterator();
    }

    private Stream<ContentVariation> getVariationsStream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.contentFragment.listAllVariations(), 16), false).map(def -> new MockContentFragment_ContentVariation_Structured((VariationDef)def, this.structuredDataKey, this.getVariationStrucuturedDataProps(def.getName())));
    }

    private ModifiableValueMap getVariationStrucuturedDataProps(String variationName) {
        Resource contentResource = this.contentFragment.getContentResource();
        try {
            return (ModifiableValueMap)ResourceUtil.getOrCreateResource((ResourceResolver)contentResource.getResourceResolver(), (String)(contentResource.getPath() + "/data/" + variationName), (String)"nt:unstructured", (String)"nt:unstructured", (boolean)false).adaptTo(ModifiableValueMap.class);
        }
        catch (PersistenceException ex) {
            throw new RuntimeException("Unable to create variation data.", ex);
        }
    }

    public void removeVariation(ContentVariation variation) throws ContentFragmentException {
        ModifiableValueMap props = this.getVariationStrucuturedDataProps(variation.getName());
        props.remove((Object)this.structuredDataKey);
    }

    public ContentVariation getResolvedVariation(String variationName) {
        throw new UnsupportedOperationException();
    }

    public FragmentData getValue() {
        throw new UnsupportedOperationException();
    }

    public void setValue(FragmentData fragmentData) throws ContentFragmentException {
        throw new UnsupportedOperationException();
    }

    public VersionDef createVersion(String label, String comment) throws ContentFragmentException {
        throw new UnsupportedOperationException();
    }

    public VersionedContent getVersionedContent(VersionDef version) throws ContentFragmentException {
        throw new UnsupportedOperationException();
    }

    public Iterator<VersionDef> listVersions() throws ContentFragmentException {
        throw new UnsupportedOperationException();
    }

    public ContentElement getVersion(VersionDef versionDef) throws ContentFragmentException {
        throw new UnsupportedOperationException();
    }
}

