/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem.context;

import com.day.cq.commons.ValueMapWrapper;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.components.ComponentContext;
import com.day.cq.wcm.api.components.EditContext;
import com.day.cq.wcm.api.designer.Design;
import com.day.cq.wcm.api.designer.Designer;
import com.day.cq.wcm.api.designer.Style;
import com.day.cq.wcm.commons.WCMUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.wcm.testing.mock.aem.context.AemContextImpl;
import javax.servlet.ServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class MockAemSlingBindings {
    private static final String RA_DESIGN_CACHE_PREFIX = MockAemSlingBindings.class.getName() + "_design_";

    private MockAemSlingBindings() {
    }

    @Nullable
    static Object resolveSlingBindingProperty(@NotNull AemContextImpl context, @NotNull String property, @Nullable SlingHttpServletRequest givenRequest) {
        SlingHttpServletRequest request = givenRequest;
        if (givenRequest == null) {
            request = context.request();
        }
        if (StringUtils.equals((CharSequence)property, (CharSequence)SlingBindingsProperty.COMPONENT_CONTEXT.key)) {
            return MockAemSlingBindings.getWcmComponentContext(request);
        }
        if (StringUtils.equals((CharSequence)property, (CharSequence)SlingBindingsProperty.EDIT_CONTEXT.key())) {
            return MockAemSlingBindings.getEditContext(request);
        }
        if (StringUtils.equals((CharSequence)property, (CharSequence)SlingBindingsProperty.PROPERTIES.key())) {
            return MockAemSlingBindings.getProperties(request);
        }
        if (StringUtils.equals((CharSequence)property, (CharSequence)SlingBindingsProperty.PAGE_MANAGER.key())) {
            return context.pageManager();
        }
        if (StringUtils.equals((CharSequence)property, (CharSequence)SlingBindingsProperty.CURRENT_PAGE.key())) {
            return MockAemSlingBindings.getCurrentPage(request);
        }
        if (StringUtils.equals((CharSequence)property, (CharSequence)SlingBindingsProperty.RESOURCE_PAGE.key())) {
            return MockAemSlingBindings.getResourcePage(request, context);
        }
        if (StringUtils.equals((CharSequence)property, (CharSequence)SlingBindingsProperty.PAGE_PROPERTIES.key())) {
            return MockAemSlingBindings.getPageProperties(request);
        }
        if (StringUtils.equals((CharSequence)property, (CharSequence)SlingBindingsProperty.COMPONENT.key())) {
            return MockAemSlingBindings.getComponent(request);
        }
        if (StringUtils.equals((CharSequence)property, (CharSequence)SlingBindingsProperty.DESIGNER.key())) {
            return MockAemSlingBindings.getDesigner(request);
        }
        if (StringUtils.equals((CharSequence)property, (CharSequence)SlingBindingsProperty.CURRENT_DESIGN.key())) {
            return MockAemSlingBindings.getCurrentDesign(request);
        }
        if (StringUtils.equals((CharSequence)property, (CharSequence)SlingBindingsProperty.RESOURCE_DESIGN.key())) {
            return MockAemSlingBindings.getResourceDesign(request, context);
        }
        if (StringUtils.equals((CharSequence)property, (CharSequence)SlingBindingsProperty.CURRENT_STYLE.key())) {
            return MockAemSlingBindings.getStyle(request);
        }
        return null;
    }

    private static ComponentContext getWcmComponentContext(SlingHttpServletRequest request) {
        return WCMUtils.getComponentContext((ServletRequest)request);
    }

    private static EditContext getEditContext(SlingHttpServletRequest request) {
        ComponentContext wcmComponentContext = MockAemSlingBindings.getWcmComponentContext(request);
        if (wcmComponentContext != null) {
            return wcmComponentContext.getEditContext();
        }
        return null;
    }

    private static ValueMap getProperties(SlingHttpServletRequest request) {
        return MockAemSlingBindings.wrap(ResourceUtil.getValueMap((Resource)request.getResource()));
    }

    private static Page getCurrentPage(SlingHttpServletRequest request) {
        ComponentContext wcmComponentContext = MockAemSlingBindings.getWcmComponentContext(request);
        if (wcmComponentContext != null) {
            return wcmComponentContext.getPage();
        }
        return null;
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    private static Page getResourcePage(SlingHttpServletRequest request, AemContextImpl context) {
        Resource resource = request.getResource();
        if (resource != null) {
            return context.pageManager().getContainingPage(resource);
        }
        return null;
    }

    private static ValueMap getPageProperties(SlingHttpServletRequest request) {
        Page currentPage = MockAemSlingBindings.getCurrentPage(request);
        if (currentPage != null) {
            return MockAemSlingBindings.wrap(currentPage.getProperties());
        }
        return null;
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    private static Component getComponent(SlingHttpServletRequest request) {
        Resource resource = request.getResource();
        if (resource != null) {
            return WCMUtils.getComponent((Resource)resource);
        }
        return null;
    }

    private static Designer getDesigner(SlingHttpServletRequest request) {
        return (Designer)request.getResourceResolver().adaptTo(Designer.class);
    }

    private static Design getCurrentDesign(SlingHttpServletRequest request) {
        Page currentPage = MockAemSlingBindings.getCurrentPage(request);
        return MockAemSlingBindings.getAndCacheDesign(currentPage, request, MockAemSlingBindings.getDesigner(request));
    }

    private static Design getResourceDesign(SlingHttpServletRequest request, AemContextImpl context) {
        return MockAemSlingBindings.getAndCacheDesign(MockAemSlingBindings.getResourcePage(request, context), request, MockAemSlingBindings.getDesigner(request));
    }

    private static Style getStyle(SlingHttpServletRequest request) {
        ComponentContext wcmComponentContext = MockAemSlingBindings.getWcmComponentContext(request);
        Design currentDesign = MockAemSlingBindings.getCurrentDesign(request);
        if (wcmComponentContext != null && currentDesign != null) {
            return currentDesign.getStyle(wcmComponentContext.getCell());
        }
        return null;
    }

    private static ValueMap wrap(ValueMap props) {
        return new ValueMapWrapper(props){};
    }

    private static Design getAndCacheDesign(Page page, SlingHttpServletRequest request, Designer designer) {
        if (page == null || designer == null) {
            return null;
        }
        String cacheKey = RA_DESIGN_CACHE_PREFIX + page.getPath();
        Design design = (Design)request.getAttribute(cacheKey);
        if (design == null) {
            design = designer.getDesign(page);
            request.setAttribute(cacheKey, (Object)design);
        }
        return design;
    }

    static enum SlingBindingsProperty {
        COMPONENT_CONTEXT("componentContext"),
        EDIT_CONTEXT("editContext"),
        PROPERTIES("properties"),
        PAGE_MANAGER("pageManager"),
        CURRENT_PAGE("currentPage"),
        RESOURCE_PAGE("resourcePage"),
        PAGE_PROPERTIES("pageProperties"),
        COMPONENT("component"),
        DESIGNER("designer"),
        CURRENT_DESIGN("currentDesign"),
        RESOURCE_DESIGN("resourceDesign"),
        CURRENT_STYLE("currentStyle");

        private final String key;

        private SlingBindingsProperty(String key) {
            this.key = key;
        }

        public String key() {
            return this.key;
        }
    }
}

