/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem.context;

import com.day.cq.dam.api.AssetManager;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.components.ComponentContext;
import com.day.cq.wcm.api.policies.ContentPolicyMapping;
import com.day.cq.wcm.commons.WCMUtils;
import com.google.common.collect.ImmutableSet;
import io.wcm.testing.mock.aem.MockAemAdapterFactory;
import io.wcm.testing.mock.aem.MockComponentContext;
import io.wcm.testing.mock.aem.MockContentPolicyStorage;
import io.wcm.testing.mock.aem.MockLayerAdapterFactory;
import io.wcm.testing.mock.aem.builder.ContentBuilder;
import io.wcm.testing.mock.aem.context.ContextResourceResolverFactory;
import io.wcm.testing.mock.aem.context.MockAemBindingsValuesProvider;
import io.wcm.testing.mock.aem.context.MockAemSlingBindings;
import io.wcm.testing.mock.aem.context.UniqueRoot;
import io.wcm.testing.mock.aem.dam.MockAemDamAdapterFactory;
import io.wcm.testing.mock.aem.dam.MockAssetHandler;
import io.wcm.testing.mock.aem.dam.MockAssetStore;
import io.wcm.testing.mock.aem.granite.MockResourceCollectionManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.testing.mock.osgi.MapUtil;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.apache.sling.testing.mock.sling.context.SlingContextImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ConsumerType;

@ConsumerType
public class AemContextImpl
extends SlingContextImpl {
    static final Set<String> DEFAULT_RUN_MODES = ImmutableSet.builder().add((Object)"publish").build();

    protected void registerDefaultServices() {
        super.registerDefaultServices();
        this.registerInjectActivateService(new MockAemAdapterFactory());
        this.registerInjectActivateService(new MockAemDamAdapterFactory());
        this.registerInjectActivateService(new MockLayerAdapterFactory());
        this.registerInjectActivateService(new MockAssetHandler());
        this.registerInjectActivateService(new MockAssetStore());
        this.registerInjectActivateService(new MockAemBindingsValuesProvider(), new Object[]{"context", this});
        this.registerInjectActivateService(new MockResourceCollectionManager());
    }

    protected void setResourceResolverType(@Nullable ResourceResolverType resourceResolverType) {
        super.setResourceResolverType(resourceResolverType);
    }

    @NotNull
    protected ResourceResolverFactory newResourceResolverFactory() {
        return ContextResourceResolverFactory.get(this.resourceResolverType, this.bundleContext());
    }

    protected void setUp() {
        super.setUp();
    }

    protected void tearDown() {
        super.tearDown();
    }

    protected final Map<String, Object> resourceResolverFactoryActivatorPropsMergeWithAemDefault(@Nullable Map<String, Object> customProps) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("resource.resolver.searchpath", new String[]{"/apps", "/libs", "/apps/foundation/components/primary", "/libs/foundation/components/primary"});
        props.put("resource.resolver.manglenamespaces", true);
        props.put("resource.resolver.allowDirect", true);
        props.put("resource.resolver.virtual", new String[]{"/:/"});
        props.put("resource.resolver.mapping", new String[]{"/-/"});
        props.put("resource.resolver.map.location", "/etc/map");
        props.put("resource.resolver.default.vanity.redirect.status", "");
        props.put("resource.resolver.virtual", "302");
        props.put("resource.resolver.enable.vanitypath", false);
        props.put("resource.resolver.vanitypath.maxEntries", -1);
        props.put("resource.resolver.vanitypath.bloomfilter.maxBytes", 1024000);
        props.put("resource.resolver.optimize.alias.resolution", true);
        props.put("resource.resolver.vanitypath.whitelist", new String[]{"/apps/", "/libs/", "/content/"});
        props.put("resource.resolver.vanitypath.blacklist", new String[]{"/content/usergenerated"});
        props.put("resource.resolver.vanity.precedence", false);
        props.put("resource.resolver.providerhandling.paranoid", false);
        if (customProps != null) {
            props.putAll(customProps);
        }
        return props;
    }

    @NotNull
    public PageManager pageManager() {
        return (PageManager)this.resourceResolver().adaptTo(PageManager.class);
    }

    @NotNull
    public AssetManager assetManager() {
        return (AssetManager)this.resourceResolver().adaptTo(AssetManager.class);
    }

    @NotNull
    public ContentBuilder create() {
        if (this.contentBuilder == null) {
            this.contentBuilder = new ContentBuilder(this);
        }
        return (ContentBuilder)this.contentBuilder;
    }

    @Nullable
    public Resource currentResource(@Nullable Resource resource) {
        Resource result = super.currentResource(resource);
        if (!this.hasWcmComponentContext()) {
            this.setCurrentPageInWcmComponentContext(this.currentPage());
        }
        return result;
    }

    @Nullable
    public Page currentPage() {
        ComponentContext context = WCMUtils.getComponentContext((ServletRequest)this.request());
        if (context != null) {
            return context.getPage();
        }
        if (this.currentResource() != null) {
            return this.pageManager().getContainingPage(this.currentResource());
        }
        return null;
    }

    @Nullable
    public Page currentPage(@Nullable String pagePath) {
        if (pagePath != null) {
            Page page = this.pageManager().getPage(pagePath);
            if (page == null) {
                throw new IllegalArgumentException("Page does not exist: " + pagePath);
            }
            return this.currentPage(page);
        }
        this.currentPage((Page)null);
        return null;
    }

    @Nullable
    public Page currentPage(@Nullable Page page) {
        if (page != null) {
            this.currentResource(page.getContentResource());
        } else {
            this.currentResource(null);
        }
        this.setCurrentPageInWcmComponentContext(page);
        return page;
    }

    private void setCurrentPageInWcmComponentContext(Page page) {
        MockComponentContext wcmComponentContext = null;
        if (page != null) {
            wcmComponentContext = new MockComponentContext(page, (SlingHttpServletRequest)this.request());
        }
        this.request().setAttribute("com.day.cq.wcm.componentcontext", wcmComponentContext);
    }

    private boolean hasWcmComponentContext() {
        return this.request().getAttribute("com.day.cq.wcm.componentcontext") != null;
    }

    @NotNull
    public UniqueRoot uniqueRoot() {
        if (this.uniqueRoot == null) {
            this.uniqueRoot = new UniqueRoot(this);
        }
        return (UniqueRoot)this.uniqueRoot;
    }

    @NotNull
    public ContentPolicyMapping contentPolicyMapping(@NotNull String resourceType, Map<String, Object> properties) {
        return MockContentPolicyStorage.storeContentPolicyMapping(resourceType, properties, this.resourceResolver());
    }

    @NotNull
    public ContentPolicyMapping contentPolicyMapping(@NotNull String resourceType, Object ... properties) {
        return this.contentPolicyMapping(resourceType, MapUtil.toMap((Object[])properties));
    }

    @Nullable
    protected Object resolveSlingBindingProperty(@NotNull String property) {
        Object result = super.resolveSlingBindingProperty(property);
        if (result == null) {
            result = MockAemSlingBindings.resolveSlingBindingProperty(this, property);
        }
        return result;
    }
}

