/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem.context;

import com.day.cq.commons.ValueMapWrapper;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.components.ComponentContext;
import com.day.cq.wcm.api.components.EditContext;
import com.day.cq.wcm.api.designer.Design;
import com.day.cq.wcm.api.designer.Designer;
import com.day.cq.wcm.api.designer.Style;
import com.day.cq.wcm.commons.WCMUtils;
import io.wcm.testing.mock.aem.context.AemContextImpl;
import javax.servlet.ServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class MockAemSlingBindings {
    private static final String RA_DESIGN_CACHE_PREFIX = MockAemSlingBindings.class.getName() + "_design_";

    private MockAemSlingBindings() {
    }

    @Nullable
    static Object resolveSlingBindingProperty(@NotNull AemContextImpl context, @NotNull String property) {
        if (StringUtils.equals((CharSequence)property, (CharSequence)SlingBindingsProperty.COMPONENT_CONTEXT.key)) {
            return MockAemSlingBindings.getWcmComponentContext(context);
        }
        if (StringUtils.equals((CharSequence)property, (CharSequence)SlingBindingsProperty.EDIT_CONTEXT.key())) {
            return MockAemSlingBindings.getEditContext(context);
        }
        if (StringUtils.equals((CharSequence)property, (CharSequence)SlingBindingsProperty.PROPERTIES.key())) {
            return MockAemSlingBindings.getProperties(context);
        }
        if (StringUtils.equals((CharSequence)property, (CharSequence)SlingBindingsProperty.PAGE_MANAGER.key())) {
            return context.pageManager();
        }
        if (StringUtils.equals((CharSequence)property, (CharSequence)SlingBindingsProperty.CURRENT_PAGE.key())) {
            return context.currentPage();
        }
        if (StringUtils.equals((CharSequence)property, (CharSequence)SlingBindingsProperty.RESOURCE_PAGE.key())) {
            return MockAemSlingBindings.getResourcePage(context);
        }
        if (StringUtils.equals((CharSequence)property, (CharSequence)SlingBindingsProperty.PAGE_PROPERTIES.key())) {
            return MockAemSlingBindings.getPageProperties(context);
        }
        if (StringUtils.equals((CharSequence)property, (CharSequence)SlingBindingsProperty.COMPONENT.key())) {
            return MockAemSlingBindings.getComponent(context);
        }
        if (StringUtils.equals((CharSequence)property, (CharSequence)SlingBindingsProperty.DESIGNER.key())) {
            return MockAemSlingBindings.getDesigner(context);
        }
        if (StringUtils.equals((CharSequence)property, (CharSequence)SlingBindingsProperty.CURRENT_DESIGN.key())) {
            return MockAemSlingBindings.getCurrentDesign(context);
        }
        if (StringUtils.equals((CharSequence)property, (CharSequence)SlingBindingsProperty.RESOURCE_DESIGN.key())) {
            return MockAemSlingBindings.getResourceDesign(context);
        }
        if (StringUtils.equals((CharSequence)property, (CharSequence)SlingBindingsProperty.CURRENT_STYLE.key())) {
            return MockAemSlingBindings.getStyle(context);
        }
        return null;
    }

    private static ComponentContext getWcmComponentContext(AemContextImpl context) {
        return WCMUtils.getComponentContext((ServletRequest)context.request());
    }

    private static EditContext getEditContext(AemContextImpl context) {
        ComponentContext wcmComponentContext = MockAemSlingBindings.getWcmComponentContext(context);
        if (wcmComponentContext != null) {
            return wcmComponentContext.getEditContext();
        }
        return null;
    }

    private static ValueMap getProperties(AemContextImpl context) {
        return MockAemSlingBindings.wrap(ResourceUtil.getValueMap((Resource)context.currentResource()));
    }

    private static Page getResourcePage(AemContextImpl context) {
        Resource resource = context.currentResource();
        if (resource != null) {
            return context.pageManager().getContainingPage(resource);
        }
        return null;
    }

    private static ValueMap getPageProperties(AemContextImpl context) {
        Page page = context.currentPage();
        if (page != null) {
            return MockAemSlingBindings.wrap(page.getProperties());
        }
        return null;
    }

    private static Component getComponent(AemContextImpl context) {
        Resource resource = context.currentResource();
        if (resource != null) {
            return WCMUtils.getComponent((Resource)resource);
        }
        return null;
    }

    private static Designer getDesigner(AemContextImpl context) {
        return (Designer)context.resourceResolver().adaptTo(Designer.class);
    }

    private static Design getCurrentDesign(AemContextImpl context) {
        return MockAemSlingBindings.getAndCacheDesign(context.currentPage(), (SlingHttpServletRequest)context.request(), MockAemSlingBindings.getDesigner(context));
    }

    private static Design getResourceDesign(AemContextImpl context) {
        return MockAemSlingBindings.getAndCacheDesign(MockAemSlingBindings.getResourcePage(context), (SlingHttpServletRequest)context.request(), MockAemSlingBindings.getDesigner(context));
    }

    private static Style getStyle(AemContextImpl context) {
        ComponentContext wcmComponentContext = MockAemSlingBindings.getWcmComponentContext(context);
        Design currentDesign = MockAemSlingBindings.getCurrentDesign(context);
        if (wcmComponentContext != null && currentDesign != null) {
            return currentDesign.getStyle(wcmComponentContext.getCell());
        }
        return null;
    }

    private static ValueMap wrap(ValueMap props) {
        return new ValueMapWrapper(props){};
    }

    private static Design getAndCacheDesign(Page page, SlingHttpServletRequest request, Designer designer) {
        if (page == null || designer == null) {
            return null;
        }
        String cacheKey = RA_DESIGN_CACHE_PREFIX + page.getPath();
        Design design = (Design)request.getAttribute(cacheKey);
        if (design == null) {
            design = designer.getDesign(page);
            request.setAttribute(cacheKey, (Object)design);
        }
        return design;
    }

    static enum SlingBindingsProperty {
        COMPONENT_CONTEXT("componentContext"),
        EDIT_CONTEXT("editContext"),
        PROPERTIES("properties"),
        PAGE_MANAGER("pageManager"),
        CURRENT_PAGE("currentPage"),
        RESOURCE_PAGE("resourcePage"),
        PAGE_PROPERTIES("pageProperties"),
        COMPONENT("component"),
        DESIGNER("designer"),
        CURRENT_DESIGN("currentDesign"),
        RESOURCE_DESIGN("resourceDesign"),
        CURRENT_STYLE("currentStyle");

        private final String key;

        private SlingBindingsProperty(String key) {
            this.key = key;
        }

        public String key() {
            return this.key;
        }
    }
}

