/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.VertxException;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.audit.Marker;
import io.vertx.ext.auth.audit.SecurityAudit;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.webauthn4j.WebAuthn4J;
import io.vertx.ext.auth.webauthn4j.WebAuthn4JCredentials;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.HttpException;
import io.vertx.ext.web.handler.WebAuthn4JHandler;
import io.vertx.ext.web.handler.impl.AuthenticationHandlerImpl;
import io.vertx.ext.web.impl.OrderListener;
import io.vertx.ext.web.impl.Origin;
import io.vertx.ext.web.impl.RoutingContextInternal;
import io.vertx.ext.web.impl.UserContextInternal;

public class WebAuthn4JHandlerImpl
extends AuthenticationHandlerImpl<WebAuthn4J>
implements WebAuthn4JHandler,
OrderListener {
    private int order = -1;
    private Route register = null;
    private Route login = null;
    private Route response = null;
    private String origin;
    private String domain;

    public WebAuthn4JHandlerImpl(WebAuthn4J webAuthN) {
        super(webAuthN);
    }

    private static boolean containsRequiredString(JsonObject json, String key) {
        try {
            if (json == null) {
                return false;
            }
            if (!json.containsKey(key)) {
                return false;
            }
            Object s = json.getValue(key);
            return s instanceof String && !"".equals(s);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    private static boolean containsOptionalString(JsonObject json, String key) {
        try {
            if (json == null) {
                return true;
            }
            if (!json.containsKey(key)) {
                return true;
            }
            Object s = json.getValue(key);
            return s instanceof String;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    private static boolean containsRequiredObject(JsonObject json, String key) {
        try {
            if (json == null) {
                return false;
            }
            if (!json.containsKey(key)) {
                return false;
            }
            JsonObject s = json.getJsonObject(key);
            return s != null;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public Future<User> authenticate(RoutingContext ctx) {
        if (this.response == null) {
            return Future.failedFuture((Throwable)new HttpException(500, (Throwable)new IllegalStateException("No callback mounted!")));
        }
        User user = ctx.user();
        if (user == null) {
            return Future.failedFuture((Throwable)new HttpException(401));
        }
        return Future.succeededFuture((Object)user);
    }

    @Override
    public WebAuthn4JHandler setupCredentialsCreateCallback(Route route) {
        this.register = route;
        if (this.order != -1) {
            this.mountRegister();
        }
        return this;
    }

    @Override
    public WebAuthn4JHandler setupCredentialsGetCallback(Route route) {
        this.login = route;
        if (this.order != -1) {
            this.mountLogin();
        }
        return this;
    }

    @Override
    public WebAuthn4JHandler setupCallback(Route route) {
        this.response = route;
        if (this.order != -1) {
            this.mountResponse();
        }
        return this;
    }

    @Override
    public WebAuthn4JHandler setOrigin(String origin) {
        if (origin != null) {
            Origin o = Origin.parse(origin);
            this.origin = o.encode();
            this.domain = o.host();
        } else {
            this.origin = null;
            this.domain = null;
        }
        return this;
    }

    private static void ok(RoutingContext ctx) {
        ctx.response().setStatusCode(204).end();
    }

    private static void ok(RoutingContext ctx, JsonObject result) {
        ctx.json(result);
    }

    @Override
    public void onOrder(int order) {
        this.order = order;
        if (this.register != null) {
            this.mountRegister();
        }
        if (this.login != null) {
            this.mountLogin();
        }
        if (this.response != null) {
            this.mountResponse();
        }
    }

    private void mountRegister() {
        this.register.method(HttpMethod.POST).order(this.order - 1).handler((Handler<RoutingContext>)((Handler)ctx -> {
            try {
                JsonObject webauthnRegister = ctx.body().asJsonObject();
                Session session = ctx.session();
                if (webauthnRegister == null || !WebAuthn4JHandlerImpl.containsRequiredString(webauthnRegister, "name")) {
                    ctx.fail(400, new IllegalArgumentException("missing 'name' field from request json"));
                } else {
                    if (session == null) {
                        ctx.fail(500, (Throwable)new VertxException("No session or session handler is missing.", true));
                        return;
                    }
                    ((WebAuthn4J)this.authProvider).createCredentialsOptions(webauthnRegister).onFailure(ctx::fail).onSuccess(credentialsOptions -> {
                        session.put("challenge", credentialsOptions.getString("challenge")).put("username", webauthnRegister.getString("name"));
                        WebAuthn4JHandlerImpl.ok(ctx, credentialsOptions);
                    });
                }
            }
            catch (IllegalArgumentException e) {
                ctx.fail(400, e);
            }
            catch (RuntimeException e) {
                ctx.fail(e);
            }
        }));
    }

    private void mountLogin() {
        this.login.method(HttpMethod.POST).order(this.order - 1).handler((Handler<RoutingContext>)((Handler)ctx -> {
            try {
                String username;
                JsonObject webauthnLogin = ctx.body().asJsonObject();
                Session session = ctx.session();
                String string = username = webauthnLogin == null ? null : webauthnLogin.getString("name");
                if (session == null) {
                    ctx.fail(500, (Throwable)new VertxException("No session or session handler is missing.", true));
                    return;
                }
                ((WebAuthn4J)this.authProvider).getCredentialsOptions(username).onFailure(ctx::fail).onSuccess(getAssertion -> {
                    session.put("challenge", getAssertion.getString("challenge")).put("username", username);
                    WebAuthn4JHandlerImpl.ok(ctx, getAssertion);
                });
            }
            catch (IllegalArgumentException e) {
                ctx.fail(400, e);
            }
            catch (RuntimeException e) {
                ctx.fail(e);
            }
        }));
    }

    private void mountResponse() {
        this.response.method(HttpMethod.POST).order(this.order - 1).handler((Handler<RoutingContext>)((Handler)ctx -> {
            try {
                JsonObject webauthnResp = ctx.body().asJsonObject();
                if (!(webauthnResp != null && WebAuthn4JHandlerImpl.containsRequiredString(webauthnResp, "id") && WebAuthn4JHandlerImpl.containsRequiredString(webauthnResp, "rawId") && WebAuthn4JHandlerImpl.containsRequiredObject(webauthnResp, "response") && WebAuthn4JHandlerImpl.containsOptionalString(webauthnResp.getJsonObject("response"), "userHandle") && WebAuthn4JHandlerImpl.containsRequiredString(webauthnResp, "type") && "public-key".equals(webauthnResp.getString("type")))) {
                    ctx.fail(400, new IllegalArgumentException("Response missing one or more of id/rawId/response[.userHandle]/type fields, or type is not public-key"));
                    return;
                }
                Session session = ctx.session();
                if (session == null) {
                    ctx.fail(500, (Throwable)new VertxException("No session or session handler is missing.", true));
                    return;
                }
                WebAuthn4JCredentials credentials = new WebAuthn4JCredentials().setOrigin(this.origin).setDomain(this.domain).setChallenge((String)session.remove("challenge")).setUsername((String)session.get("username")).setWebauthn(webauthnResp);
                SecurityAudit audit = ((RoutingContextInternal)ctx).securityAudit();
                audit.credentials((Credentials)credentials);
                ((WebAuthn4J)this.authProvider).authenticate((Credentials)credentials).onSuccess(user -> {
                    audit.audit(Marker.AUTHENTICATION, true);
                    ((UserContextInternal)ctx.userContext()).setUser((User)user);
                    session.regenerateId();
                    WebAuthn4JHandlerImpl.ok(ctx);
                }).onFailure(cause -> {
                    audit.audit(Marker.AUTHENTICATION, false);
                    ctx.fail(400, (Throwable)cause);
                });
            }
            catch (IllegalArgumentException e) {
                ctx.fail(400, e);
            }
            catch (RuntimeException e) {
                ctx.fail(e);
            }
        }));
    }
}

