/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.netty.handler.codec.http.QueryStringDecoder;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.internal.http.HttpServerRequestInternal;
import io.vertx.core.net.HostAndPort;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.web.AllowForwardHeaders;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.WebServerRequest;
import io.vertx.ext.web.impl.ForwardedParser;
import io.vertx.ext.web.impl.ServerWebSocketWrapper;
import java.nio.charset.Charset;
import java.util.Map;

class HttpServerRequestWrapper
extends io.vertx.core.internal.http.HttpServerRequestWrapper
implements WebServerRequest {
    private final ForwardedParser forwardedParser;
    private final RoutingContext ctx;
    private boolean modified;
    private HttpMethod method;
    private String path;
    private String query;
    private String uri;
    private String absoluteURI;
    private MultiMap params;

    HttpServerRequestWrapper(HttpServerRequest request, AllowForwardHeaders allowForward, RoutingContext ctx) {
        super((HttpServerRequestInternal)request);
        this.forwardedParser = new ForwardedParser(request, allowForward);
        this.ctx = ctx;
    }

    void changeTo(HttpMethod method, String uri) {
        this.modified = true;
        this.method = method;
        this.uri = uri;
        this.query = null;
        this.absoluteURI = null;
        int queryIndex = uri.indexOf(63);
        if (queryIndex != -1) {
            int fragmentIndex = uri.indexOf(35, queryIndex);
            this.path = uri.substring(0, queryIndex);
            this.query = fragmentIndex != -1 ? uri.substring(queryIndex + 1, fragmentIndex) : uri.substring(queryIndex + 1);
        } else {
            int fragmentIndex = uri.indexOf(35);
            this.path = fragmentIndex != -1 ? uri.substring(0, fragmentIndex) : uri;
        }
    }

    public HttpMethod method() {
        if (!this.modified) {
            return this.delegate.method();
        }
        return this.method;
    }

    public String uri() {
        if (!this.modified) {
            return this.delegate.uri();
        }
        return this.uri;
    }

    public String path() {
        if (!this.modified) {
            return this.delegate.path();
        }
        return this.path;
    }

    public String query() {
        if (!this.modified) {
            return this.delegate.query();
        }
        return this.query;
    }

    public MultiMap params() {
        if (!this.modified) {
            return this.delegate.params();
        }
        if (this.params == null) {
            QueryStringDecoder queryStringDecoder;
            Map prms;
            this.params = MultiMap.caseInsensitiveMultiMap();
            if (this.query != null && !(prms = (queryStringDecoder = new QueryStringDecoder(this.uri, Charset.forName(this.delegate.getParamsCharset()))).parameters()).isEmpty()) {
                for (Map.Entry entry : prms.entrySet()) {
                    this.params.add((String)entry.getKey(), (Iterable)entry.getValue());
                }
            }
        }
        return this.params;
    }

    public String getParam(String param) {
        if (!this.modified) {
            return this.delegate.getParam(param);
        }
        return this.params().get(param);
    }

    public HttpServerRequest setParamsCharset(String s) {
        String old = this.delegate.getParamsCharset();
        this.delegate.setParamsCharset(s);
        if (!s.equals(old)) {
            this.params = null;
        }
        return this;
    }

    public SocketAddress remoteAddress() {
        return this.forwardedParser.remoteAddress();
    }

    public String absoluteURI() {
        if (!this.modified) {
            return this.forwardedParser.absoluteURI();
        }
        if (this.absoluteURI == null) {
            String scheme = this.forwardedParser.scheme();
            HostAndPort host = this.forwardedParser.authority();
            this.absoluteURI = scheme != null && host != null ? scheme + "://" + String.valueOf(host) + this.uri : this.uri;
        }
        return this.absoluteURI;
    }

    public String scheme() {
        return this.forwardedParser.scheme();
    }

    public @Nullable HostAndPort authority() {
        return this.forwardedParser.authority();
    }

    public Future<ServerWebSocket> toWebSocket() {
        return this.delegate.toWebSocket().map(ws -> new ServerWebSocketWrapper((ServerWebSocket)ws, this.authority(), this.scheme(), this.isSSL(), this.remoteAddress()));
    }

    public boolean isSSL() {
        return this.forwardedParser.isSSL();
    }

    @Override
    public RoutingContext routingContext() {
        return this.ctx;
    }
}

