/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.Vertx;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.CookieSameSite;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.ext.auth.VertxContextPRNG;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.CSRFHandler;
import io.vertx.ext.web.impl.Origin;
import io.vertx.ext.web.impl.RoutingContextInternal;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class CSRFHandlerImpl
implements CSRFHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CSRFHandlerImpl.class);
    private static final Base64.Encoder BASE64 = Base64.getMimeEncoder();
    private final VertxContextPRNG random;
    private final Mac mac;
    private boolean nagHttps;
    private String cookieName = "XSRF-TOKEN";
    private String cookiePath = "/";
    private String headerName = "X-XSRF-TOKEN";
    private long timeout = 1800000L;
    private Origin origin;
    private boolean httpOnly;

    public CSRFHandlerImpl(Vertx vertx, String secret) {
        try {
            if (secret.length() <= 8) {
                LOG.warn((Object)"CSRF secret is very short (<= 8 bytes)");
            }
            this.random = VertxContextPRNG.current((Vertx)vertx);
            this.mac = Mac.getInstance("HmacSHA256");
            this.mac.init(new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), "HmacSHA256"));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CSRFHandler setOrigin(String origin) {
        this.origin = Origin.parse(origin);
        return this;
    }

    @Override
    public CSRFHandler setCookieName(String cookieName) {
        this.cookieName = cookieName;
        return this;
    }

    @Override
    public CSRFHandler setCookiePath(String cookiePath) {
        this.cookiePath = cookiePath;
        return this;
    }

    @Override
    public CSRFHandler setCookieHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
        return this;
    }

    @Override
    public CSRFHandler setHeaderName(String headerName) {
        this.headerName = headerName;
        return this;
    }

    @Override
    public CSRFHandler setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    @Override
    public CSRFHandler setNagHttps(boolean nag) {
        this.nagHttps = nag;
        return this;
    }

    private String generateAndStoreToken(RoutingContext ctx) {
        byte[] salt = new byte[32];
        this.random.nextBytes(salt);
        String saltPlusToken = BASE64.encodeToString(salt) + "." + System.currentTimeMillis();
        String signature = BASE64.encodeToString(this.mac.doFinal(saltPlusToken.getBytes(StandardCharsets.US_ASCII)));
        String token = saltPlusToken + "." + signature;
        ctx.addCookie(Cookie.cookie((String)this.cookieName, (String)token).setPath(this.cookiePath).setHttpOnly(this.httpOnly).setSameSite(CookieSameSite.STRICT));
        Session session = ctx.session();
        if (session != null) {
            session.put(this.headerName, session.id() + "/" + token);
        }
        return token;
    }

    private String getTokenFromSession(RoutingContext ctx) {
        int idx;
        Session session = ctx.session();
        if (session == null) {
            return null;
        }
        String sessionToken = (String)session.get(this.headerName);
        if (sessionToken != null && (idx = sessionToken.indexOf(47)) != -1 && session.id() != null && session.id().equals(sessionToken.substring(0, idx))) {
            return sessionToken.substring(idx + 1);
        }
        return null;
    }

    private static boolean isBlank(String s) {
        return s == null || s.trim().isEmpty();
    }

    private static long parseLong(String s) {
        if (CSRFHandlerImpl.isBlank(s)) {
            return -1L;
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            LOG.trace((Object)"Invalid Token format", (Throwable)e);
            return -1L;
        }
    }

    private boolean isValidOrigin(RoutingContext ctx) {
        if (this.origin != null) {
            String source = ctx.request().getHeader(HttpHeaders.ORIGIN);
            if (CSRFHandlerImpl.isBlank(source) && CSRFHandlerImpl.isBlank(source = ctx.request().getHeader(HttpHeaders.REFERER))) {
                LOG.trace((Object)"ORIGIN and REFERER request headers are both absent/empty");
                return false;
            }
            if (!this.origin.sameOrigin(source)) {
                LOG.trace((Object)"Protocol/Host/Port do not fully match");
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isValidRequest(RoutingContext ctx) {
        long ts;
        String[] tokens;
        byte[] cookieBytes;
        Cookie cookie = ctx.getCookie(this.cookieName);
        String header = ctx.request().getHeader(this.headerName);
        if (header == null) {
            if (!((RoutingContextInternal)ctx).seenHandler(2)) {
                ctx.fail(new IllegalStateException("BodyHandler is required to process POST requests"));
                return false;
            }
            header = ctx.request().getFormAttribute(this.headerName);
        }
        if (header == null || cookie == null || CSRFHandlerImpl.isBlank(header)) {
            ctx.fail(403, new IllegalArgumentException("Token provided via HTTP Header/Form is absent/empty"));
            return false;
        }
        String cookieValue = cookie.getValue();
        if (cookieValue == null || CSRFHandlerImpl.isBlank(cookieValue)) {
            ctx.fail(403, new IllegalArgumentException("Token provided via HTTP Header/Form is absent/empty"));
            return false;
        }
        byte[] headerBytes = header.getBytes(StandardCharsets.UTF_8);
        if (!MessageDigest.isEqual(headerBytes, cookieBytes = cookieValue.getBytes(StandardCharsets.UTF_8))) {
            ctx.fail(403, new IllegalArgumentException("Token provided via HTTP Header and via Cookie are not equal"));
            return false;
        }
        if (ctx.session() != null) {
            Session session = ctx.session();
            String sessionToken = (String)session.get(this.headerName);
            if (sessionToken == null) {
                ctx.fail(403, new IllegalArgumentException("No Token has been added to the session"));
                return false;
            }
            int idx = sessionToken.indexOf(47);
            if (idx != -1 && session.id() != null && session.id().equals(sessionToken.substring(0, idx))) {
                String challenge = sessionToken.substring(idx + 1);
                if (!MessageDigest.isEqual(challenge.getBytes(StandardCharsets.UTF_8), headerBytes)) {
                    ctx.fail(403, new IllegalArgumentException("Token has been used or is outdated"));
                    return false;
                }
            } else {
                ctx.fail(403, new IllegalArgumentException("Token has been issued for a different session"));
                return false;
            }
        }
        if ((tokens = header.split("\\.")).length != 3) {
            ctx.fail(403);
            return false;
        }
        byte[] saltPlusToken = (tokens[0] + "." + tokens[1]).getBytes(StandardCharsets.US_ASCII);
        Mac idx = this.mac;
        synchronized (idx) {
            saltPlusToken = this.mac.doFinal(saltPlusToken);
        }
        byte[] signature = BASE64.encode(saltPlusToken);
        if (!MessageDigest.isEqual(signature, tokens[2].getBytes(StandardCharsets.US_ASCII))) {
            ctx.fail(403, new IllegalArgumentException("Token signature does not match"));
            return false;
        }
        if (ctx.session() != null) {
            ctx.session().remove(this.headerName);
        }
        if ((ts = CSRFHandlerImpl.parseLong(tokens[1])) == -1L) {
            ctx.fail(403);
            return false;
        }
        if (System.currentTimeMillis() > ts + this.timeout) {
            ctx.fail(403, new IllegalArgumentException("CSRF validity expired"));
            return false;
        }
        return true;
    }

    public void handle(RoutingContext ctx) {
        String uri;
        if (this.nagHttps && (uri = ctx.request().absoluteURI()) != null && !uri.startsWith("https:")) {
            LOG.trace((Object)("Using session cookies without https could make you susceptible to session hijacking: " + uri));
        }
        HttpMethod method = ctx.request().method();
        Session session = ctx.session();
        if (!this.isValidOrigin(ctx)) {
            ctx.fail(403, new IllegalStateException("Invalid Origin"));
            return;
        }
        switch (method.name()) {
            case "GET": {
                String[] parts;
                long ts;
                String sessionToken;
                String token = session == null ? this.generateAndStoreToken(ctx) : ((sessionToken = this.getTokenFromSession(ctx)) == null ? this.generateAndStoreToken(ctx) : ((ts = CSRFHandlerImpl.parseLong((parts = sessionToken.split("\\."))[1])) == -1L ? this.generateAndStoreToken(ctx) : (System.currentTimeMillis() <= ts + this.timeout ? sessionToken : this.generateAndStoreToken(ctx))));
                ctx.put(this.headerName, token);
                ctx.next();
                break;
            }
            case "POST": 
            case "PUT": 
            case "DELETE": 
            case "PATCH": {
                if (!this.isValidRequest(ctx)) break;
                String token = this.generateAndStoreToken(ctx);
                ctx.put(this.headerName, token);
                ctx.next();
                break;
            }
            default: {
                ctx.next();
            }
        }
    }
}

