/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.authentication.TokenCredentials;
import io.vertx.ext.auth.jwt.JWTAuth;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.JWTAuthHandler;
import io.vertx.ext.web.handler.impl.HTTPAuthorizationHandler;

public class JWTAuthHandlerImpl
extends HTTPAuthorizationHandler<JWTAuth>
implements JWTAuthHandler {
    public JWTAuthHandlerImpl(JWTAuth authProvider) {
        super(authProvider, HTTPAuthorizationHandler.Type.BEARER);
    }

    @Override
    public void parseCredentials(RoutingContext context, Handler<AsyncResult<Credentials>> handler) {
        this.parseAuthorization(context, false, (Handler<AsyncResult<String>>)((Handler)parseAuthorization -> {
            if (parseAuthorization.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)parseAuthorization.cause()));
                return;
            }
            handler.handle((Object)Future.succeededFuture((Object)new TokenCredentials((String)parseAuthorization.result())));
        }));
    }

    @Override
    public String authenticateHeader(RoutingContext context) {
        if (this.realm != null && this.realm.length() > 0) {
            return "Bearer realm=\"" + this.realm + "\"";
        }
        return null;
    }
}

