/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.HeaderTooLongException;
import io.vertx.ext.web.impl.HttpServerRequestWrapper;
import io.vertx.ext.web.impl.RouteImpl;
import io.vertx.ext.web.impl.RouterImpl;
import java.util.Iterator;
import java.util.Set;

public abstract class RoutingContextImplBase
implements RoutingContext {
    private static final Logger log = LoggerFactory.getLogger(RoutingContextImplBase.class);
    private final Set<RouteImpl> routes;
    protected final String mountPoint;
    protected final HttpServerRequest request;
    protected Iterator<RouteImpl> iter;
    protected RouteImpl currentRoute;

    protected RoutingContextImplBase(String mountPoint, HttpServerRequest request, Set<RouteImpl> routes) {
        this.mountPoint = mountPoint;
        this.request = new HttpServerRequestWrapper(request);
        this.routes = routes;
        this.iter = routes.iterator();
    }

    @Override
    public String mountPoint() {
        return this.mountPoint;
    }

    @Override
    public Route currentRoute() {
        return this.currentRoute;
    }

    protected void restart() {
        this.iter = this.routes.iterator();
        this.currentRoute = null;
        this.next();
    }

    protected boolean iterateNext() {
        boolean failed = this.failed();
        while (this.iter.hasNext()) {
            RouteImpl route = this.iter.next();
            if (!route.matches(this, this.mountPoint(), failed)) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)("Route matches: " + route));
            }
            try {
                this.currentRoute = route;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Calling the " + (failed ? "failure" : "") + " handler"));
                }
                if (failed) {
                    route.handleFailure(this);
                } else {
                    route.handleContext(this);
                }
            }
            catch (Throwable t) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Throwable thrown from handler", t);
                }
                if (!failed) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Failing the routing");
                    }
                    this.fail(t);
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Failure in handling failure");
                }
                this.unhandledFailure(-1, t, route.router());
            }
            return true;
        }
        return false;
    }

    protected void unhandledFailure(int statusCode, Throwable failure, RouterImpl router) {
        int code;
        int n = code = statusCode != -1 ? statusCode : 500;
        if (failure != null) {
            if (router.exceptionHandler() != null) {
                router.exceptionHandler().handle((Object)failure);
            } else {
                log.error((Object)"Unexpected exception in route", failure);
            }
            if (!this.response().ended() && failure instanceof HeaderTooLongException) {
                this.response().setStatusCode(400);
                this.response().putHeader("Content-Type", "text/plain");
                this.response().end(failure.getMessage());
            }
        }
        if (!this.response().ended()) {
            try {
                this.response().setStatusCode(code);
            }
            catch (IllegalArgumentException e) {
                this.response().setStatusMessage(HttpResponseStatus.valueOf((int)code).reasonPhrase()).setStatusCode(code);
            }
            this.response().end(this.response().getStatusMessage());
        }
    }
}

