/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.sstore.impl;

import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.shareddata.Shareable;
import io.vertx.core.shareddata.impl.ClusterSerializable;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.impl.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class SessionImpl
implements Session,
ClusterSerializable,
Shareable {
    private static final Logger log = LoggerFactory.getLogger(SessionImpl.class);
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final byte TYPE_LONG = 1;
    private static final byte TYPE_INT = 2;
    private static final byte TYPE_SHORT = 3;
    private static final byte TYPE_BYTE = 4;
    private static final byte TYPE_DOUBLE = 5;
    private static final byte TYPE_FLOAT = 6;
    private static final byte TYPE_CHAR = 7;
    private static final byte TYPE_BOOLEAN = 8;
    private static final byte TYPE_STRING = 9;
    private static final byte TYPE_BUFFER = 10;
    private static final byte TYPE_BYTES = 11;
    private static final byte TYPE_SERIALIZABLE = 12;
    private static final byte TYPE_CLUSTER_SERIALIZABLE = 13;
    private String id;
    private long timeout;
    private Map<String, Object> data;
    private long lastAccessed;
    private boolean destroyed;

    public SessionImpl() {
    }

    public SessionImpl(long timeout) {
        this.id = UUID.randomUUID().toString();
        this.timeout = timeout;
        this.lastAccessed = System.currentTimeMillis();
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public long timeout() {
        return this.timeout;
    }

    @Override
    public <T> T get(String key) {
        Object obj = this.getData().get(key);
        return (T)obj;
    }

    @Override
    public Session put(String key, Object obj) {
        this.getData().put(key, obj);
        return this;
    }

    @Override
    public <T> T remove(String key) {
        Object obj = this.getData().remove(key);
        return (T)obj;
    }

    @Override
    public Map<String, Object> data() {
        return this.getData();
    }

    @Override
    public long lastAccessed() {
        return this.lastAccessed;
    }

    @Override
    public void setAccessed() {
        this.lastAccessed = System.currentTimeMillis();
    }

    @Override
    public void destroy() {
        this.destroyed = true;
        this.data = null;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void writeToBuffer(Buffer buff) {
        byte[] bytes = this.id.getBytes(UTF8);
        buff.appendInt(bytes.length).appendBytes(bytes);
        buff.appendLong(this.timeout);
        Buffer dataBuf = this.writeDataToBuffer();
        buff.appendBuffer(dataBuf);
    }

    public int readFromBuffer(int pos, Buffer buffer) {
        int len = buffer.getInt(pos);
        byte[] bytes = buffer.getBytes(pos += 4, pos + len);
        this.id = new String(bytes, UTF8);
        this.timeout = buffer.getLong(pos += len);
        pos += 8;
        pos = this.readDataFromBuffer(pos, buffer);
        return pos;
    }

    private Map<String, Object> getData() {
        if (this.data == null) {
            this.data = new HashMap<String, Object>();
        }
        return this.data;
    }

    private Buffer writeDataToBuffer() {
        try {
            Map<String, Object> data = this.getData();
            Buffer buffer = Buffer.buffer();
            buffer.appendInt(data.size());
            for (Map.Entry<String, Object> entry : data.entrySet()) {
                byte[] bytes;
                String key = entry.getKey();
                byte[] keyBytes = key.getBytes(UTF8);
                buffer.appendInt(keyBytes.length).appendBytes(keyBytes);
                Object val = entry.getValue();
                if (val instanceof Long) {
                    buffer.appendByte((byte)1).appendLong(((Long)val).longValue());
                    continue;
                }
                if (val instanceof Integer) {
                    buffer.appendByte((byte)2).appendInt(((Integer)val).intValue());
                    continue;
                }
                if (val instanceof Short) {
                    buffer.appendByte((byte)3).appendShort(((Short)val).shortValue());
                    continue;
                }
                if (val instanceof Byte) {
                    buffer.appendByte((byte)4).appendByte(((Byte)val).byteValue());
                    continue;
                }
                if (val instanceof Double) {
                    buffer.appendByte((byte)5).appendDouble(((Double)val).doubleValue());
                    continue;
                }
                if (val instanceof Float) {
                    buffer.appendByte((byte)6).appendFloat(((Float)val).floatValue());
                    continue;
                }
                if (val instanceof Character) {
                    buffer.appendByte((byte)7).appendShort((short)((Character)val).charValue());
                    continue;
                }
                if (val instanceof Boolean) {
                    buffer.appendByte((byte)8).appendByte((byte)((Boolean)val != false ? 1 : 0));
                    continue;
                }
                if (val instanceof String) {
                    bytes = ((String)val).getBytes(UTF8);
                    buffer.appendByte((byte)9).appendInt(bytes.length).appendBytes(bytes);
                    continue;
                }
                if (val instanceof Buffer) {
                    Buffer buff = (Buffer)val;
                    buffer.appendByte((byte)10).appendInt(buff.length()).appendBuffer(buff);
                    continue;
                }
                if (val instanceof byte[]) {
                    bytes = (byte[])val;
                    buffer.appendByte((byte)11).appendInt(bytes.length).appendBytes(bytes);
                    continue;
                }
                if (val instanceof Serializable) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(baos));
                    oos.writeObject(val);
                    oos.flush();
                    byte[] bytes2 = baos.toByteArray();
                    buffer.appendByte((byte)12).appendInt(bytes2.length).appendBytes(bytes2);
                    continue;
                }
                if (val instanceof ClusterSerializable) {
                    buffer.appendByte((byte)13);
                    String className = val.getClass().getName();
                    byte[] classNameBytes = className.getBytes(UTF8);
                    buffer.appendInt(classNameBytes.length).appendBytes(classNameBytes);
                    ((ClusterSerializable)val).writeToBuffer(buffer);
                    continue;
                }
                throw new IllegalStateException("Invalid type for data in session: " + val.getClass());
            }
            return buffer;
        }
        catch (IOException e) {
            throw new VertxException((Throwable)e);
        }
    }

    private int readDataFromBuffer(int pos, Buffer buffer) {
        try {
            int entries = buffer.getInt(pos);
            pos += 4;
            this.data = new HashMap<String, Object>(entries);
            for (int i = 0; i < entries; ++i) {
                Object val;
                int keylen = buffer.getInt(pos);
                byte[] keyBytes = buffer.getBytes(pos += 4, pos + keylen);
                pos += keylen;
                String key = new String(keyBytes, UTF8);
                byte type = buffer.getByte(pos++);
                switch (type) {
                    case 1: {
                        val = buffer.getLong(pos);
                        pos += 8;
                        break;
                    }
                    case 2: {
                        val = buffer.getInt(pos);
                        pos += 4;
                        break;
                    }
                    case 3: {
                        val = buffer.getShort(pos);
                        pos += 2;
                        break;
                    }
                    case 4: {
                        val = buffer.getByte(pos);
                        ++pos;
                        break;
                    }
                    case 6: {
                        val = Float.valueOf(buffer.getFloat(pos));
                        pos += 4;
                        break;
                    }
                    case 5: {
                        val = buffer.getDouble(pos);
                        pos += 8;
                        break;
                    }
                    case 7: {
                        short s = buffer.getShort(pos);
                        pos += 2;
                        val = Character.valueOf((char)s);
                        break;
                    }
                    case 8: {
                        byte b = buffer.getByte(pos);
                        ++pos;
                        val = b == 1;
                        break;
                    }
                    case 9: {
                        int len = buffer.getInt(pos);
                        byte[] bytes = buffer.getBytes(pos += 4, pos + len);
                        val = new String(bytes, UTF8);
                        pos += len;
                        break;
                    }
                    case 10: {
                        int len = buffer.getInt(pos);
                        byte[] bytes = buffer.getBytes(pos += 4, pos + len);
                        val = Buffer.buffer((byte[])bytes);
                        pos += len;
                        break;
                    }
                    case 11: {
                        int len = buffer.getInt(pos);
                        val = buffer.getBytes(pos += 4, pos + len);
                        pos += len;
                        break;
                    }
                    case 12: {
                        int len = buffer.getInt(pos);
                        byte[] bytes = buffer.getBytes(pos += 4, pos + len);
                        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                        ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(bais));
                        val = ois.readObject();
                        pos += len;
                        break;
                    }
                    case 13: {
                        int classNameLen = buffer.getInt(pos);
                        byte[] classNameBytes = buffer.getBytes(pos += 4, pos + classNameLen);
                        pos += classNameLen;
                        String className = new String(classNameBytes, UTF8);
                        Class<?> clazz = Utils.getClassLoader().loadClass(className);
                        ClusterSerializable obj = (ClusterSerializable)clazz.newInstance();
                        pos = obj.readFromBuffer(pos, buffer);
                        val = obj;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid serialized type: " + type);
                    }
                }
                this.data.put(key, val);
            }
            return pos;
        }
        catch (Exception e) {
            throw new VertxException((Throwable)e);
        }
    }
}

