/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.Cookie;
import io.vertx.ext.web.FileUpload;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.impl.RouteImpl;
import io.vertx.ext.web.impl.RoutingContextImplBase;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class RoutingContextWrapper
extends RoutingContextImplBase {
    protected final RoutingContext inner;
    private final String mountPoint;

    public RoutingContextWrapper(String mountPoint, HttpServerRequest request, Iterator<RouteImpl> iter, RoutingContext inner) {
        super(mountPoint, request, iter);
        this.inner = inner;
        String parentMountPoint = inner.mountPoint();
        if (mountPoint.charAt(mountPoint.length() - 1) == '/') {
            mountPoint = mountPoint.substring(0, mountPoint.length() - 1);
        }
        this.mountPoint = parentMountPoint == null ? mountPoint : parentMountPoint + mountPoint;
    }

    @Override
    public HttpServerRequest request() {
        return this.inner.request();
    }

    @Override
    public HttpServerResponse response() {
        return this.inner.response();
    }

    @Override
    public void fail(int statusCode) {
        this.inner.fail(statusCode);
    }

    @Override
    public void fail(Throwable throwable) {
        this.inner.fail(throwable);
    }

    @Override
    public RoutingContext put(String key, Object obj) {
        this.inner.put(key, obj);
        return this;
    }

    @Override
    public <T> T get(String key) {
        return this.inner.get(key);
    }

    @Override
    public Map<String, Object> data() {
        return this.inner.data();
    }

    @Override
    public Vertx vertx() {
        return this.inner.vertx();
    }

    @Override
    public int addHeadersEndHandler(Handler<Future> handler) {
        return this.inner.addHeadersEndHandler(handler);
    }

    @Override
    public boolean removeHeadersEndHandler(int handlerID) {
        return this.inner.removeHeadersEndHandler(handlerID);
    }

    @Override
    public int addBodyEndHandler(Handler<Void> handler) {
        return this.inner.addBodyEndHandler(handler);
    }

    @Override
    public boolean removeBodyEndHandler(int handlerID) {
        return this.inner.removeBodyEndHandler(handlerID);
    }

    @Override
    public void setSession(Session session) {
        this.inner.setSession(session);
    }

    @Override
    public Session session() {
        return this.inner.session();
    }

    @Override
    public void setUser(User user) {
        this.inner.setUser(user);
    }

    @Override
    public void clearUser() {
        this.inner.clearUser();
    }

    @Override
    public User user() {
        return this.inner.user();
    }

    @Override
    public void next() {
        if (!super.iterateNext()) {
            this.inner.next();
        }
    }

    @Override
    public boolean failed() {
        return this.inner.failed();
    }

    @Override
    public Throwable failure() {
        return this.inner.failure();
    }

    @Override
    public int statusCode() {
        return this.inner.statusCode();
    }

    @Override
    public String mountPoint() {
        return this.mountPoint;
    }

    @Override
    public String normalisedPath() {
        return this.inner.normalisedPath();
    }

    @Override
    public Cookie getCookie(String name) {
        return this.inner.getCookie(name);
    }

    @Override
    public RoutingContext addCookie(Cookie cookie) {
        this.inner.addCookie(cookie);
        return this;
    }

    @Override
    public Cookie removeCookie(String name) {
        return this.inner.removeCookie(name);
    }

    @Override
    public int cookieCount() {
        return this.inner.cookieCount();
    }

    @Override
    public Set<Cookie> cookies() {
        return this.inner.cookies();
    }

    @Override
    public String getBodyAsString() {
        return this.inner.getBodyAsString();
    }

    @Override
    public String getBodyAsString(String encoding) {
        return this.inner.getBodyAsString(encoding);
    }

    @Override
    public JsonObject getBodyAsJson() {
        return this.inner.getBodyAsJson();
    }

    @Override
    public Buffer getBody() {
        return this.inner.getBody();
    }

    @Override
    public void setBody(Buffer body) {
        this.inner.setBody(body);
    }

    @Override
    public Set<FileUpload> fileUploads() {
        return this.inner.fileUploads();
    }

    @Override
    public String getAcceptableContentType() {
        return this.inner.getAcceptableContentType();
    }

    @Override
    public void setAcceptableContentType(String contentType) {
        this.inner.setAcceptableContentType(contentType);
    }
}

