require 'vertx/buffer'
require 'vertx-web/template_engine'
require 'vertx-web/routing_context'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.templ.HandlebarsTemplateEngine
module VertxWeb
  #  A template engine that uses the Handlebars library.
  class HandlebarsTemplateEngine < ::VertxWeb::TemplateEngine
    # @private
    # @param j_del [::VertxWeb::HandlebarsTemplateEngine] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWeb::HandlebarsTemplateEngine] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == HandlebarsTemplateEngine
    end
    def @@j_api_type.wrap(obj)
      HandlebarsTemplateEngine.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebTempl::HandlebarsTemplateEngine.java_class
    end
    # @param [::VertxWeb::RoutingContext] arg0 
    # @param [String] arg1 
    # @param [String] arg2 
    # @yield 
    # @return [void]
    def render(arg0=nil,arg1=nil,arg2=nil)
      if arg0.class.method_defined?(:j_del) && arg1.class == String && block_given? && arg2 == nil
        return @j_del.java_method(:render, [Java::IoVertxExtWeb::RoutingContext.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0.j_del,arg1,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::Buffer) : nil) }))
      elsif arg0.class.method_defined?(:j_del) && arg1.class == String && arg2.class == String && block_given?
        return @j_del.java_method(:render, [Java::IoVertxExtWeb::RoutingContext.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0.j_del,arg1,arg2,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::Buffer) : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling render(#{arg0},#{arg1},#{arg2})"
    end
    # @return [true,false]
    def caching_enabled?
      if !block_given?
        return @j_del.java_method(:isCachingEnabled, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling caching_enabled?()"
    end
    #  Create a template engine using defaults
    # @return [::VertxWeb::HandlebarsTemplateEngine] the engine
    def self.create
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebTempl::HandlebarsTemplateEngine.java_method(:create, []).call(),::VertxWeb::HandlebarsTemplateEngine)
      end
      raise ArgumentError, "Invalid arguments when calling create()"
    end
    #  Set the extension for the engine
    # @param [String] extension the extension
    # @return [::VertxWeb::HandlebarsTemplateEngine] a reference to this for fluency
    def set_extension(extension=nil)
      if extension.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:setExtension, [Java::java.lang.String.java_class]).call(extension),::VertxWeb::HandlebarsTemplateEngine)
      end
      raise ArgumentError, "Invalid arguments when calling set_extension(#{extension})"
    end
    #  Set the max cache size for the engine
    # @param [Fixnum] maxCacheSize the maxCacheSize
    # @return [::VertxWeb::HandlebarsTemplateEngine] a reference to this for fluency
    def set_max_cache_size(maxCacheSize=nil)
      if maxCacheSize.class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:setMaxCacheSize, [Java::int.java_class]).call(maxCacheSize),::VertxWeb::HandlebarsTemplateEngine)
      end
      raise ArgumentError, "Invalid arguments when calling set_max_cache_size(#{maxCacheSize})"
    end
  end
end
