/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.openapi.router.internal.handler;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import io.vertx.openapi.contract.Operation;
import io.vertx.openapi.validation.ResponseValidator;
import io.vertx.openapi.validation.ValidatableResponse;
import io.vertx.openapi.validation.ValidatedRequest;
import io.vertx.openapi.validation.ValidatorException;

public abstract class ResponseValidationHandler
implements Handler<RoutingContext> {
    private final ResponseValidator responseValidator;

    protected ResponseValidationHandler(ResponseValidator responseValidator) {
        this.responseValidator = responseValidator;
    }

    public void handle(RoutingContext routingContext) {
        ValidatedRequest validatedRequest = (ValidatedRequest)routingContext.get("openApiValidatedRequest");
        Operation operation = (Operation)routingContext.currentRoute().getMetadata("openApiOperation");
        this.processRequest(validatedRequest, operation, routingContext).compose(validatableResponse -> this.responseValidator.validate(validatableResponse, operation.getOperationId())).compose(validatedResponse -> validatedResponse.send(routingContext.response())).onFailure(e -> {
            if (e instanceof ValidatorException) {
                this.handleValidatorException((ValidatorException)e, routingContext);
            } else {
                routingContext.fail(e);
            }
        });
    }

    abstract Future<ValidatableResponse> processRequest(ValidatedRequest var1, Operation var2, RoutingContext var3);

    protected void handleValidatorException(ValidatorException ve, RoutingContext rtx) {
        rtx.fail((Throwable)ve);
    }
}

