/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.graphql.schema.impl;

import graphql.schema.DataFetchingEnvironment;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.impl.ContextInternal;
import io.vertx.ext.web.handler.graphql.schema.VertxDataFetcher;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;

public class FutureDataFetcherImpl<T>
implements VertxDataFetcher<T> {
    private final Function<DataFetchingEnvironment, Future<T>> dataFetcher;
    private final Function<DataFetchingEnvironment, Context> contextProvider;

    public FutureDataFetcherImpl(Function<DataFetchingEnvironment, Future<T>> dataFetcher, Function<DataFetchingEnvironment, Context> contextProvider) {
        this.dataFetcher = Objects.requireNonNull(dataFetcher, "dataFetcher is null");
        this.contextProvider = Objects.requireNonNull(contextProvider, "contextProvider is null");
    }

    public CompletionStage<T> get(DataFetchingEnvironment env) {
        Promise promise;
        ContextInternal context = (ContextInternal)this.contextProvider.apply(env);
        if (context == null) {
            promise = Promise.promise();
            this.invokeDataFetcher(env, promise);
        } else {
            promise = context.promise();
            context.runOnContext(v -> this.invokeDataFetcher(env, promise));
        }
        return promise.future().toCompletionStage();
    }

    private void invokeDataFetcher(DataFetchingEnvironment env, Promise<T> promise) {
        this.dataFetcher.apply(env).onComplete(promise);
    }
}

