/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.common.template;

import io.vertx.ext.web.common.template.TemplateEngine;
import io.vertx.ext.web.common.template.impl.ConcurrentLRUCache;
import java.util.Objects;

public abstract class CachingTemplateEngine<T>
implements TemplateEngine {
    public static final String DISABLE_TEMPL_CACHING_PROP_NAME = "io.vertx.ext.web.TemplateEngine.disableCache";
    private final boolean enableCache;
    protected final ConcurrentLRUCache<String, T> cache;
    @Deprecated
    protected String extension;

    @Deprecated
    protected CachingTemplateEngine(String ext, int maxCacheSize) {
        this(maxCacheSize);
        Objects.requireNonNull(ext);
        this.doSetExtension(ext);
    }

    protected CachingTemplateEngine(int maxCacheSize) {
        boolean bl = this.enableCache = !Boolean.getBoolean(DISABLE_TEMPL_CACHING_PROP_NAME);
        if (maxCacheSize < 1) {
            throw new IllegalArgumentException("maxCacheSize must be >= 1");
        }
        this.cache = new ConcurrentLRUCache(maxCacheSize);
    }

    @Override
    public boolean isCachingEnabled() {
        return this.enableCache;
    }

    @Deprecated
    protected String adjustLocation(String location) {
        if (this.extension != null && !location.endsWith(this.extension)) {
            location = location + this.extension;
        }
        return location;
    }

    @Deprecated
    protected void doSetExtension(String ext) {
        this.extension = ext.charAt(0) == '.' ? ext : "." + ext;
    }
}

