/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.client;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Handler;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.impl.HttpContext;
import io.vertx.ext.web.client.impl.WebClientSessionAware;
import io.vertx.ext.web.client.spi.CookieStore;

@VertxGen
public interface WebClientSession
extends WebClient {
    public static WebClientSession create(WebClient webClient) {
        return WebClientSession.create(webClient, CookieStore.build());
    }

    @GenIgnore(value={"permitted-type"})
    public static WebClientSession create(WebClient webClient, CookieStore cookieStore) {
        return new WebClientSessionAware(webClient, cookieStore);
    }

    @Fluent
    @GenIgnore(value={"permitted-type"})
    public WebClientSession addHeader(CharSequence var1, CharSequence var2);

    @Fluent
    public WebClientSession addHeader(String var1, String var2);

    @Fluent
    @GenIgnore(value={"permitted-type"})
    public WebClientSession addHeader(CharSequence var1, Iterable<CharSequence> var2);

    @Fluent
    @GenIgnore(value={"permitted-type"})
    public WebClientSession addHeader(String var1, Iterable<String> var2);

    @Fluent
    @GenIgnore(value={"permitted-type"})
    public WebClientSession removeHeader(CharSequence var1);

    @Fluent
    public WebClientSession removeHeader(String var1);

    @GenIgnore(value={"permitted-type"})
    public CookieStore cookieStore();

    @Override
    @GenIgnore
    public WebClientSession addInterceptor(Handler<HttpContext<?>> var1);
}

