/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.service;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.api.service.impl.OpenAPIRouterHandlerImpl;
import io.vertx.openapi.contract.Operation;
import io.vertx.openapi.validation.ResponseValidator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;

public interface OpenAPIRouterHandler
extends Handler<RoutingContext> {
    public static final String OPENAPI_EXTENSION = "x-vertx-event-bus";
    public static final String OPENAPI_EXTENSION_ADDRESS = "address";
    public static final String OPENAPI_EXTENSION_METHOD_NAME = "method";

    public static OpenAPIRouterHandler create(Vertx vertx, Operation operation, ResponseValidator validator) {
        return OpenAPIRouterHandler.create(vertx, operation, new DeliveryOptions(), (o, r) -> new JsonObject(), validator);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OpenAPIRouterHandler create(Vertx vertx, Operation operation, DeliveryOptions deliveryOptions, BiFunction<Operation, RoutingContext, JsonObject> extraPayloadMapper, ResponseValidator validator) {
        String address;
        Object ebExtension = operation.getExtensions().get(OPENAPI_EXTENSION);
        Objects.requireNonNull(ebExtension, "No eventbus configuration found for Operation: " + operation.getOperationId());
        RuntimeException invalidConfig = new RuntimeException("Invalid eventbus configuration found for Operation: " + operation.getOperationId());
        String method = operation.getOperationId();
        if (ebExtension instanceof String) {
            address = (String)ebExtension;
        } else {
            if (!(ebExtension instanceof JsonObject)) throw invalidConfig;
            Object addressObject = ((JsonObject)ebExtension).getValue(OPENAPI_EXTENSION_ADDRESS);
            if (!(addressObject instanceof String)) {
                throw invalidConfig;
            }
            address = (String)addressObject;
            Object methodObject = ((JsonObject)ebExtension).getValue(OPENAPI_EXTENSION_METHOD_NAME);
            if (methodObject != null) {
                if (!(methodObject instanceof String)) throw invalidConfig;
                method = (String)methodObject;
            }
        }
        DeliveryOptions delOpts = Optional.ofNullable(deliveryOptions).orElse(new DeliveryOptions());
        delOpts.addHeader("action", method);
        return new OpenAPIRouterHandlerImpl(vertx.eventBus(), address, delOpts, extraPayloadMapper, validator);
    }
}

