/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.service;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.ext.web.api.service.ServiceResponse;
import java.util.Base64;
import java.util.Map;

public class ServiceResponseConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    static void fromJson(Iterable<Map.Entry<String, Object>> json, ServiceResponse obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "payload": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setPayload(Buffer.buffer((byte[])BASE64_DECODER.decode((String)member.getValue())));
                    break;
                }
                case "statusCode": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setStatusCode(((Number)member.getValue()).intValue());
                    break;
                }
                case "statusMessage": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setStatusMessage((String)member.getValue());
                }
            }
        }
    }

    static void toJson(ServiceResponse obj, JsonObject json) {
        ServiceResponseConverter.toJson(obj, json.getMap());
    }

    static void toJson(ServiceResponse obj, Map<String, Object> json) {
        if (obj.getPayload() != null) {
            json.put("payload", BASE64_ENCODER.encodeToString(obj.getPayload().getBytes()));
        }
        if (obj.getStatusCode() != null) {
            json.put("statusCode", obj.getStatusCode());
        }
        if (obj.getStatusMessage() != null) {
            json.put("statusMessage", obj.getStatusMessage());
        }
    }
}

