require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.api.RequestParameter
module VertxWebApiContract
  #  Request parameter holder
  class RequestParameter
    # @private
    # @param j_del [::VertxWebApiContract::RequestParameter] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWebApiContract::RequestParameter] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == RequestParameter
    end
    def @@j_api_type.wrap(obj)
      RequestParameter.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebApi::RequestParameter.java_class
    end
    #  Set parameter name
    # @param [String] name 
    # @return [void]
    def set_name(name=nil)
      if name.class == String && !block_given?
        return @j_del.java_method(:setName, [Java::java.lang.String.java_class]).call(name)
      end
      raise ArgumentError, "Invalid arguments when calling set_name(#{name})"
    end
    #  Set value
    # @param [Object] value 
    # @return [void]
    def set_value(value=nil)
      if ::Vertx::Util::unknown_type.accept?(value) && !block_given?
        return @j_del.java_method(:setValue, [Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(value))
      end
      raise ArgumentError, "Invalid arguments when calling set_value(#{value})"
    end
    #  Get parameter name
    # @return [String] 
    def get_name
      if !block_given?
        return @j_del.java_method(:getName, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling get_name()"
    end
    #  If value is a map of fields, it returns keys of map, otherwise it returns null
    # @return [Array<String>] 
    def get_object_keys
      if !block_given?
        return @j_del.java_method(:getObjectKeys, []).call().to_a.map { |elt| elt }
      end
      raise ArgumentError, "Invalid arguments when calling get_object_keys()"
    end
    #  If value is a map of fields, it returns value of field with key provided, otherwise it returns null
    # @param [String] key 
    # @return [::VertxWebApiContract::RequestParameter] 
    def get_object_value(key=nil)
      if key.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:getObjectValue, [Java::java.lang.String.java_class]).call(key),::VertxWebApiContract::RequestParameter)
      end
      raise ArgumentError, "Invalid arguments when calling get_object_value(#{key})"
    end
    #  Returns true if value of RequestParameter is a map of fields
    # @return [true,false] 
    def object?
      if !block_given?
        return @j_del.java_method(:isObject, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling object?()"
    end
    #  Returns null if value is not a list, otherwise it returns value
    # @return [Array<::VertxWebApiContract::RequestParameter>] 
    def get_array
      if !block_given?
        return @j_del.java_method(:getArray, []).call().to_a.map { |elt| ::Vertx::Util::Utils.safe_create(elt,::VertxWebApiContract::RequestParameter) }
      end
      raise ArgumentError, "Invalid arguments when calling get_array()"
    end
    #  Returns true if value of RequestParameter is an array
    # @return [true,false] 
    def array?
      if !block_given?
        return @j_del.java_method(:isArray, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling array?()"
    end
    #  Returns null if value is not a String, otherwise it returns value
    # @return [String] 
    def get_string
      if !block_given?
        return @j_del.java_method(:getString, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling get_string()"
    end
    #  Returns true if value of RequestParameter is a String instance
    # @return [true,false] 
    def string?
      if !block_given?
        return @j_del.java_method(:isString, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling string?()"
    end
    #  Returns null if value is not an Integer, otherwise it returns value
    # @return [Fixnum] 
    def get_integer
      if !block_given?
        return @j_del.java_method(:getInteger, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling get_integer()"
    end
    #  Returns true if value of RequestParameter is an Integer instance
    # @return [true,false] 
    def integer?
      if !block_given?
        return @j_del.java_method(:isInteger, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling integer?()"
    end
    #  Returns null if value is not a Long, otherwise it returns value
    # @return [Fixnum] 
    def get_long
      if !block_given?
        return @j_del.java_method(:getLong, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling get_long()"
    end
    #  Returns true if value of RequestParameter is a Long instance
    # @return [true,false] 
    def long?
      if !block_given?
        return @j_del.java_method(:isLong, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling long?()"
    end
    #  Returns null if value is not a Float, otherwise it returns value
    # @return [Float] 
    def get_float
      if !block_given?
        return @j_del.java_method(:getFloat, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling get_float()"
    end
    #  Returns true if value of RequestParameter is a Float instance
    # @return [true,false] 
    def float?
      if !block_given?
        return @j_del.java_method(:isFloat, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling float?()"
    end
    #  Returns null if value is not a Double, otherwise it returns value
    # @return [Float] 
    def get_double
      if !block_given?
        return @j_del.java_method(:getDouble, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling get_double()"
    end
    #  Returns true if value of RequestParameter is a Double instance
    # @return [true,false] 
    def double?
      if !block_given?
        return @j_del.java_method(:isDouble, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling double?()"
    end
    #  Returns null if value is not a Boolean, otherwise it returns value
    # @return [true,false] 
    def get_boolean?
      if !block_given?
        return @j_del.java_method(:getBoolean, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling get_boolean?()"
    end
    #  Returns true if value of RequestParameter is a Boolean instance
    # @return [true,false] 
    def boolean?
      if !block_given?
        return @j_del.java_method(:isBoolean, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling boolean?()"
    end
    #  Returns null if value is not a JsonObject, otherwise it returns value
    # @return [Hash{String => Object}] 
    def get_json_object
      if !block_given?
        return @j_del.java_method(:getJsonObject, []).call() != nil ? JSON.parse(@j_del.java_method(:getJsonObject, []).call().encode) : nil
      end
      raise ArgumentError, "Invalid arguments when calling get_json_object()"
    end
    #  Returns true if value of RequestParameter is a JsonObject instance
    # @return [true,false] 
    def json_object?
      if !block_given?
        return @j_del.java_method(:isJsonObject, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling json_object?()"
    end
    #  Returns null if value is not a JsonArray, otherwise it returns value
    # @return [Array<String,Object>] 
    def get_json_array
      if !block_given?
        return @j_del.java_method(:getJsonArray, []).call() != nil ? JSON.parse(@j_del.java_method(:getJsonArray, []).call().encode) : nil
      end
      raise ArgumentError, "Invalid arguments when calling get_json_array()"
    end
    #  Returns true if value of RequestParameter is a JsonArray instance
    # @return [true,false] 
    def json_array?
      if !block_given?
        return @j_del.java_method(:isJsonArray, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling json_array?()"
    end
    #  Returns true if value is null
    # @return [true,false] 
    def null?
      if !block_given?
        return @j_del.java_method(:isNull, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling null?()"
    end
    #  Alias of {::VertxWebApiContract::RequestParameter#is_null}
    # @return [true,false] 
    def empty?
      if !block_given?
        return @j_del.java_method(:isEmpty, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling empty?()"
    end
    #  Merge this request parameter with another one. Note: the parameter passed by argument has the priority
    # @param [::VertxWebApiContract::RequestParameter] otherParameter 
    # @return [::VertxWebApiContract::RequestParameter] 
    def merge(otherParameter=nil)
      if otherParameter.class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:merge, [Java::IoVertxExtWebApi::RequestParameter.java_class]).call(otherParameter.j_del),::VertxWebApiContract::RequestParameter)
      end
      raise ArgumentError, "Invalid arguments when calling merge(#{otherParameter})"
    end
    # @overload create(value)
    #   @param [Object] value 
    # @overload create(name,value)
    #   @param [String] name 
    #   @param [Object] value 
    # @return [::VertxWebApiContract::RequestParameter]
    def self.create(param_1=nil,param_2=nil)
      if ::Vertx::Util::unknown_type.accept?(param_1) && !block_given? && param_2 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebApi::RequestParameter.java_method(:create, [Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(param_1)),::VertxWebApiContract::RequestParameter)
      elsif param_1.class == String && ::Vertx::Util::unknown_type.accept?(param_2) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebApi::RequestParameter.java_method(:create, [Java::java.lang.String.java_class,Java::java.lang.Object.java_class]).call(param_1,::Vertx::Util::Utils.to_object(param_2)),::VertxWebApiContract::RequestParameter)
      end
      raise ArgumentError, "Invalid arguments when calling create(#{param_1},#{param_2})"
    end
  end
end
