/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.contract;

import io.vertx.codegen.annotations.VertxGen;

public class RouterFactoryException
extends RuntimeException {
    private ErrorType type;

    public RouterFactoryException(String message, ErrorType type) {
        super(message);
        this.type = type;
    }

    public ErrorType type() {
        return this.type;
    }

    public static RouterFactoryException createPathNotFoundException(String pathName) {
        return new RouterFactoryException(pathName + " not found inside specification", ErrorType.PATH_NOT_FOUND);
    }

    public static RouterFactoryException createOperationIdNotFoundException(String operationId) {
        return new RouterFactoryException(operationId + " not found inside specification", ErrorType.OPERATION_ID_NOT_FOUND);
    }

    public static RouterFactoryException createSpecInvalidException(String message) {
        return new RouterFactoryException(message, ErrorType.SPEC_INVALID);
    }

    public static RouterFactoryException createSpecNotExistsException(String path) {
        return new RouterFactoryException("Wrong specification url/path: " + path, ErrorType.INVALID_SPEC_PATH);
    }

    public static RouterFactoryException createMissingSecurityHandler(String securitySchema) {
        return new RouterFactoryException("Missing handler for security requirement: " + securitySchema, ErrorType.MISSING_SECURITY_HANDLER);
    }

    public static RouterFactoryException createMissingSecurityHandler(String securitySchema, String securityScope) {
        return new RouterFactoryException("Missing handler for security requirement: " + securitySchema + ":" + securityScope, ErrorType.MISSING_SECURITY_HANDLER);
    }

    @VertxGen
    public static enum ErrorType {
        PATH_NOT_FOUND,
        OPERATION_ID_NOT_FOUND,
        SPEC_INVALID,
        MISSING_SECURITY_HANDLER,
        INVALID_SPEC_PATH,
        PATH_PARAMETERS_COMBINATION_NOT_SUPPORTED;

    }
}

