/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.unit.collect;

import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.unit.collect.impl.EventBusCollectorImpl;
import io.vertx.ext.unit.impl.TestCompletionImpl;
import io.vertx.ext.unit.report.Reporter;
import io.vertx.ext.unit.report.ReportingOptions;
import io.vertx.ext.unit.report.TestSuiteReport;

@VertxGen
public interface EventBusCollector {
    public static final String EVENT_TEST_SUITE_BEGIN = "testSuiteBegin";
    public static final String EVENT_TEST_SUITE_END = "testSuiteEnd";
    public static final String EVENT_TEST_SUITE_ERROR = "testSuiteError";
    public static final String EVENT_TEST_CASE_BEGIN = "testCaseBegin";
    public static final String EVENT_TEST_CASE_END = "testCaseEnd";

    public static EventBusCollector create(Vertx vertx, ReportingOptions options) {
        Reporter[] reporters = (Reporter[])options.getReporters().stream().map(reportOptions -> Reporter.reporter(vertx, reportOptions)).toArray(Reporter[]::new);
        TestCompletionImpl reporter = new TestCompletionImpl(reporters);
        return new EventBusCollectorImpl(vertx, reporter);
    }

    public static EventBusCollector create(Vertx vertx, Handler<TestSuiteReport> reporter) {
        return new EventBusCollectorImpl(vertx, reporter);
    }

    public MessageConsumer register(String var1);

    @GenIgnore
    public Handler<Message<JsonObject>> asMessageHandler();
}

