/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.unit.impl;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.TestCompletion;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.TestOptions;
import io.vertx.ext.unit.TestSuite;
import io.vertx.ext.unit.impl.Helper;
import io.vertx.ext.unit.impl.TestCaseImpl;
import io.vertx.ext.unit.impl.TestCompletionImpl;
import io.vertx.ext.unit.impl.TestSuiteRunner;
import io.vertx.ext.unit.report.Reporter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TestSuiteImpl
implements TestSuite {
    private static volatile Handler<TestSuiteRunner> defaultRunner;
    private final String name;
    private volatile Handler<TestContext> before;
    private volatile Handler<TestContext> beforeEach;
    private volatile Handler<TestContext> after;
    private volatile Handler<TestContext> afterEach;
    private final List<TestCaseImpl> testCases = new ArrayList<TestCaseImpl>();

    static void setDefaultRunner(Handler<TestSuiteRunner> runner) {
        defaultRunner = runner;
    }

    public TestSuiteImpl(String name) {
        this.name = name;
    }

    public TestSuiteImpl(Object testSuiteObject) {
        Class<?> suiteClass = testSuiteObject.getClass();
        this.name = suiteClass.getName();
        block12: for (Method method : suiteClass.getMethods()) {
            int modifiers = method.getModifiers();
            String methodName = method.getName();
            if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers) || !Arrays.equals(method.getParameterTypes(), new Class[]{TestContext.class})) continue;
            Handler handler = context -> {
                try {
                    method.invoke(testSuiteObject, context);
                }
                catch (IllegalAccessException e) {
                    Helper.uncheckedThrow(e);
                }
                catch (InvocationTargetException e) {
                    Helper.uncheckedThrow(e.getCause());
                }
            };
            switch (methodName) {
                case "before": {
                    this.before((Handler<TestContext>)handler);
                    continue block12;
                }
                case "after": {
                    this.after((Handler<TestContext>)handler);
                    continue block12;
                }
                case "beforeEach": {
                    this.beforeEach((Handler<TestContext>)handler);
                    continue block12;
                }
                case "afterEach": {
                    this.afterEach((Handler<TestContext>)handler);
                    continue block12;
                }
                default: {
                    if (!methodName.startsWith("test") || methodName.length() <= 4) continue block12;
                    this.test(methodName, (Handler<TestContext>)handler);
                }
            }
        }
    }

    public List<TestCaseImpl> testCases() {
        return this.testCases;
    }

    @Override
    public TestSuite before(Handler<TestContext> callback) {
        this.before = callback;
        return this;
    }

    @Override
    public TestSuite beforeEach(Handler<TestContext> callback) {
        this.beforeEach = callback;
        return this;
    }

    @Override
    public TestSuite after(Handler<TestContext> handler) {
        this.after = handler;
        return this;
    }

    @Override
    public TestSuite afterEach(Handler<TestContext> handler) {
        this.afterEach = handler;
        return this;
    }

    @Override
    public TestSuite test(String name, Handler<TestContext> testCase) {
        return this.test(name, 1, testCase);
    }

    @Override
    public TestSuite test(String name, int repeat, Handler<TestContext> testCase) {
        this.testCases.add(new TestCaseImpl(name, repeat, testCase));
        return this;
    }

    @Override
    public TestCompletion run() {
        return this.run(null, new TestOptions());
    }

    @Override
    public TestCompletion run(Vertx vertx) {
        return this.run(vertx, new TestOptions());
    }

    @Override
    public TestCompletion run(TestOptions options) {
        return this.run(null, options);
    }

    @Override
    public TestCompletion run(Vertx vertx, TestOptions options) {
        Reporter[] reporters = (Reporter[])options.getReporters().stream().map(reportOptions -> Reporter.reporter(vertx, reportOptions)).toArray(Reporter[]::new);
        TestCompletionImpl completion = new TestCompletionImpl(reporters);
        TestSuiteRunner runner = this.runner().setVertx(vertx).setTimeout(options.getTimeout()).setUseEventLoop(options.isUseEventLoop()).setReporter(completion);
        if (defaultRunner != null) {
            defaultRunner.handle((Object)runner);
        } else {
            runner.run();
        }
        return completion;
    }

    public TestSuiteRunner runner() {
        return new TestSuiteRunner(this.name, this.before, this.after, this.beforeEach, this.afterEach, new ArrayList<TestCaseImpl>(this.testCases));
    }
}

