/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.stomp.impl;

import io.vertx.ext.stomp.StompServerConnection;
import io.vertx.ext.stomp.impl.Transaction;
import java.util.ArrayList;
import java.util.List;

public class Transactions {
    private static final Transactions INSTANCE = new Transactions();
    private final List<Transaction> transactions = new ArrayList<Transaction>();

    public static Transactions instance() {
        return INSTANCE;
    }

    private Transactions() {
    }

    public synchronized Transaction getTransaction(StompServerConnection connection, String txId) {
        return this.transactions.stream().filter(t -> t.connection().equals(connection) && t.id().equals(txId)).findFirst().orElse(null);
    }

    public synchronized boolean registerTransaction(StompServerConnection connection, String txId) {
        if (this.getTransaction(connection, txId) != null) {
            return false;
        }
        this.transactions.add(new Transaction(connection, txId));
        return true;
    }

    public synchronized boolean unregisterTransaction(StompServerConnection connection, String id) {
        Transaction transaction = this.getTransaction(connection, id);
        return transaction != null && this.transactions.remove(transaction);
    }

    public synchronized void unregisterTransactionsFromConnection(StompServerConnection connection) {
        this.transactions.stream().filter(transaction -> transaction.connection().equals(connection)).sorted().forEach(this.transactions::remove);
    }

    public synchronized int getTransactionCount() {
        return this.transactions.size();
    }
}

