/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.stomp;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.stomp.Acknowledgement;
import io.vertx.ext.stomp.BridgeOptions;
import io.vertx.ext.stomp.Destination;
import io.vertx.ext.stomp.DestinationFactory;
import io.vertx.ext.stomp.Frame;
import io.vertx.ext.stomp.ServerFrame;
import io.vertx.ext.stomp.StompServer;
import io.vertx.ext.stomp.StompServerConnection;
import io.vertx.ext.stomp.impl.DefaultStompHandler;
import java.util.List;

@VertxGen
public interface StompServerHandler
extends Handler<ServerFrame> {
    public static StompServerHandler create(Vertx vertx) {
        return new DefaultStompHandler(vertx);
    }

    @Fluent
    public StompServerHandler receivedFrameHandler(Handler<ServerFrame> var1);

    @Fluent
    public StompServerHandler connectHandler(Handler<ServerFrame> var1);

    @Fluent
    public StompServerHandler stompHandler(Handler<ServerFrame> var1);

    @Fluent
    public StompServerHandler subscribeHandler(Handler<ServerFrame> var1);

    @Fluent
    public StompServerHandler unsubscribeHandler(Handler<ServerFrame> var1);

    @Fluent
    public StompServerHandler sendHandler(Handler<ServerFrame> var1);

    @Fluent
    public StompServerHandler closeHandler(Handler<StompServerConnection> var1);

    public void onClose(StompServerConnection var1);

    @Fluent
    public StompServerHandler commitHandler(Handler<ServerFrame> var1);

    @Fluent
    public StompServerHandler abortHandler(Handler<ServerFrame> var1);

    @Fluent
    public StompServerHandler beginHandler(Handler<ServerFrame> var1);

    @Fluent
    public StompServerHandler disconnectHandler(Handler<ServerFrame> var1);

    @Fluent
    public StompServerHandler ackHandler(Handler<ServerFrame> var1);

    @Fluent
    public StompServerHandler nackHandler(Handler<ServerFrame> var1);

    @Fluent
    public StompServerHandler onAuthenticationRequest(StompServer var1, String var2, String var3, Handler<AsyncResult<Boolean>> var4);

    @Fluent
    public StompServerHandler authProvider(AuthProvider var1);

    public List<Destination> getDestinations();

    public Destination getDestination(String var1);

    @Fluent
    public StompServerHandler onAck(StompServerConnection var1, Frame var2, List<Frame> var3);

    @Fluent
    public StompServerHandler onNack(StompServerConnection var1, Frame var2, List<Frame> var3);

    @Fluent
    public StompServerHandler onAckHandler(Handler<Acknowledgement> var1);

    @Fluent
    public StompServerHandler onNackHandler(Handler<Acknowledgement> var1);

    @Fluent
    public StompServerHandler pingHandler(Handler<StompServerConnection> var1);

    public Destination getOrCreateDestination(String var1);

    @Fluent
    public StompServerHandler destinationFactory(DestinationFactory var1);

    @Fluent
    public StompServerHandler bridge(BridgeOptions var1);
}

