/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.impl.NetClientBuilder;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.spi.ConnectionFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public abstract class ConnectionFactoryBase
implements ConnectionFactory {
    public static final String NATIVE_TRANSPORT_REQUIRED = "The Vertx instance must use a native transport in order to connect to connect through domain sockets";
    protected final VertxInternal vertx;
    private final Map<JsonObject, NetClient> clients;
    protected final Supplier<? extends Future<? extends SqlConnectOptions>> options;
    protected final CloseFuture clientCloseFuture = new CloseFuture();

    protected ConnectionFactoryBase(VertxInternal vertx, Supplier<? extends Future<? extends SqlConnectOptions>> options) {
        this.vertx = vertx;
        this.options = options;
        this.clients = new HashMap<JsonObject, NetClient>();
    }

    private NetClient createNetClient(NetClientOptions options) {
        options.setReconnectAttempts(0);
        return new NetClientBuilder(this.vertx, options).closeFuture(this.clientCloseFuture).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NetClient netClient(NetClientOptions options) {
        NetClient client;
        if (options.getClass() != NetClientOptions.class) {
            options = new NetClientOptions(options);
        }
        options.setHostnameVerificationAlgorithm("");
        JsonObject key = options.toJson();
        ConnectionFactoryBase connectionFactoryBase = this;
        synchronized (connectionFactoryBase) {
            client = this.clients.get(key);
            if (client == null) {
                client = this.createNetClient(options);
                this.clients.put(key, client);
            }
        }
        return client;
    }

    public static ContextInternal asEventLoopContext(ContextInternal ctx) {
        if (ctx.isEventLoopContext()) {
            return ctx;
        }
        return ctx.owner().createEventLoopContext(ctx.nettyEventLoop(), ctx.workerPool(), ctx.classLoader());
    }

    public Future<Connection> connect(ContextInternal context, SqlConnectOptions options) {
        PromiseInternal promise = context.promise();
        context.emit((Object)promise, p -> this.doConnectWithRetry(options, (PromiseInternal<Connection>)p, options.getReconnectAttempts()));
        return promise.future();
    }

    @Override
    public Future<SqlConnection> connect(Context context) {
        return this.connect(context, this.options.get());
    }

    public void close(Promise<Void> promise) {
        this.clientCloseFuture.close(promise);
    }

    private void doConnectWithRetry(SqlConnectOptions options, PromiseInternal<Connection> promise, int remainingAttempts) {
        ContextInternal ctx = promise.context();
        this.doConnectInternal(options, ctx).onComplete(ar -> {
            if (ar.succeeded()) {
                promise.complete(ar.result());
            } else if (remainingAttempts > 0) {
                ctx.owner().setTimer(options.getReconnectInterval(), id -> this.doConnectWithRetry(options, promise, remainingAttempts - 1));
            } else {
                promise.fail(ar.cause());
            }
        });
    }

    protected abstract Future<Connection> doConnectInternal(SqlConnectOptions var1, ContextInternal var2);
}

