/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.tck;

import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.data.Numeric;
import io.vertx.sqlclient.tck.DataTypeTestBase;
import java.time.LocalDate;
import java.time.LocalTime;
import org.junit.Test;

public abstract class TextDataTypeDecodeTestBase
extends DataTypeTestBase {
    @Test
    public void testSmallInt(TestContext ctx) {
        this.testDecodeGeneric(ctx, "test_int_2", Short.class, (short)Short.MAX_VALUE);
    }

    @Test
    public void testInteger(TestContext ctx) {
        this.testDecodeGeneric(ctx, "test_int_4", Integer.class, Integer.MAX_VALUE);
    }

    @Test
    public void testBigInt(TestContext ctx) {
        this.testDecodeGeneric(ctx, "test_int_8", Long.class, Long.MAX_VALUE);
    }

    @Test
    public void testFloat4(TestContext ctx) {
        this.testDecodeGeneric(ctx, "test_float_4", Float.class, Float.valueOf(3.40282E38f));
    }

    @Test
    public void testDouble(TestContext ctx) {
        this.testDecodeGeneric(ctx, "test_float_8", Double.class, Double.MAX_VALUE);
    }

    @Test
    public void testNumeric(TestContext ctx) {
        this.testDecodeGeneric(ctx, "test_numeric", Numeric.class, Numeric.parse((String)"999.99"));
    }

    @Test
    public void testDecimal(TestContext ctx) {
        this.testDecodeGeneric(ctx, "test_decimal", Numeric.class, Numeric.parse((String)"12345"));
    }

    @Test
    public void testBoolean(TestContext ctx) {
        this.testDecodeGeneric(ctx, "test_boolean", Boolean.class, true);
    }

    @Test
    public void testChar(TestContext ctx) {
        this.testDecodeGeneric(ctx, "test_char", String.class, "testchar");
    }

    @Test
    public void testVarchar(TestContext ctx) {
        this.testDecodeGeneric(ctx, "test_varchar", String.class, "testvarchar");
    }

    @Test
    public void testDate(TestContext ctx) {
        this.testDecodeGeneric(ctx, "test_date", LocalDate.class, LocalDate.of(2019, 1, 1));
    }

    @Test
    public void testTime(TestContext ctx) {
        this.testDecodeGeneric(ctx, "test_time", LocalTime.class, LocalTime.of(18, 45, 2));
    }

    protected <T> void testDecodeGeneric(TestContext ctx, String columnName, Class<T> clazz, T expected) {
        Async async = ctx.async();
        this.connector.connect(ctx.asyncAssertSuccess(conn -> conn.query("SELECT " + columnName + " FROM basicdatatype WHERE id = 1", ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = result.iterator().next();
            ctx.assertEquals(expected, row.getValue(0));
            ctx.assertEquals(expected, row.getValue(columnName));
            async.complete();
        }))));
    }
}

