/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.tck;

import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.tck.PreparedQueryTestBase;
import org.junit.Test;

public abstract class PreparedQueryCachedTestBase
extends PreparedQueryTestBase {
    @Override
    public void setUp(TestContext ctx) throws Exception {
        super.setUp(ctx);
        this.options.setCachePreparedStatements(true);
    }

    @Test
    public void testConcurrent(TestContext ctx) {
        this.connector.connect(ctx.asyncAssertSuccess(conn -> {
            int i;
            Async[] asyncs = new Async[10];
            for (i = 0; i < 10; ++i) {
                asyncs[i] = ctx.async();
            }
            for (i = 0; i < 10; ++i) {
                Async async = asyncs[i];
                conn.prepare(this.statement("SELECT * FROM Fortune WHERE id=", ""), ctx.asyncAssertSuccess(ps -> ps.execute(Tuple.of((Object)1), ctx.asyncAssertSuccess(results -> {
                    ctx.assertEquals((Object)1, (Object)results.size());
                    Row row = results.iterator().next();
                    ctx.assertEquals((Object)1, (Object)row.getInteger(0));
                    ctx.assertEquals((Object)"fortune: No such file or directory", (Object)row.getString(1));
                    async.complete();
                }))));
            }
        }));
    }
}

