/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.ext.stomp;

import io.reactivex.rxjava3.core.Single;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.stomp.BridgeOptions;
import io.vertx.ext.stomp.Frame;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rxjava3.Helper;
import io.vertx.rxjava3.SingleHelper;
import io.vertx.rxjava3.ext.auth.User;
import io.vertx.rxjava3.ext.auth.authentication.AuthenticationProvider;
import io.vertx.rxjava3.ext.stomp.Acknowledgement;
import io.vertx.rxjava3.ext.stomp.Destination;
import io.vertx.rxjava3.ext.stomp.DestinationFactory;
import io.vertx.rxjava3.ext.stomp.ServerFrame;
import io.vertx.rxjava3.ext.stomp.StompServerConnection;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import java.util.List;
import java.util.stream.Collectors;

@RxGen(value=io.vertx.ext.stomp.StompServerHandler.class)
public class StompServerHandler
implements RxDelegate,
Handler<ServerFrame> {
    public static final TypeArg<StompServerHandler> __TYPE_ARG = new TypeArg(obj -> new StompServerHandler((io.vertx.ext.stomp.StompServerHandler)obj), StompServerHandler::getDelegate);
    private final io.vertx.ext.stomp.StompServerHandler delegate;
    private static final TypeArg<Destination> TYPE_ARG_0 = new TypeArg(o1 -> Destination.newInstance((io.vertx.ext.stomp.Destination)o1), o1 -> o1.getDelegate());

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StompServerHandler that = (StompServerHandler)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public StompServerHandler(io.vertx.ext.stomp.StompServerHandler delegate) {
        this.delegate = delegate;
    }

    public StompServerHandler(Object delegate) {
        this.delegate = (io.vertx.ext.stomp.StompServerHandler)delegate;
    }

    public io.vertx.ext.stomp.StompServerHandler getDelegate() {
        return this.delegate;
    }

    public void handle(ServerFrame event) {
        this.delegate.handle((Object)event.getDelegate());
    }

    public static StompServerHandler create(io.vertx.rxjava3.core.Vertx vertx) {
        StompServerHandler ret = StompServerHandler.newInstance(io.vertx.ext.stomp.StompServerHandler.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    public StompServerHandler receivedFrameHandler(Handler<ServerFrame> handler) {
        this.delegate.receivedFrameHandler(Helper.convertHandler(handler, event -> ServerFrame.newInstance(event)));
        return this;
    }

    public StompServerHandler connectHandler(Handler<ServerFrame> handler) {
        this.delegate.connectHandler(Helper.convertHandler(handler, event -> ServerFrame.newInstance(event)));
        return this;
    }

    public StompServerHandler stompHandler(Handler<ServerFrame> handler) {
        this.delegate.stompHandler(Helper.convertHandler(handler, event -> ServerFrame.newInstance(event)));
        return this;
    }

    public StompServerHandler subscribeHandler(Handler<ServerFrame> handler) {
        this.delegate.subscribeHandler(Helper.convertHandler(handler, event -> ServerFrame.newInstance(event)));
        return this;
    }

    public StompServerHandler unsubscribeHandler(Handler<ServerFrame> handler) {
        this.delegate.unsubscribeHandler(Helper.convertHandler(handler, event -> ServerFrame.newInstance(event)));
        return this;
    }

    public StompServerHandler sendHandler(Handler<ServerFrame> handler) {
        this.delegate.sendHandler(Helper.convertHandler(handler, event -> ServerFrame.newInstance(event)));
        return this;
    }

    public StompServerHandler closeHandler(Handler<StompServerConnection> handler) {
        this.delegate.closeHandler(Helper.convertHandler(handler, event -> StompServerConnection.newInstance(event)));
        return this;
    }

    public void onClose(StompServerConnection connection) {
        this.delegate.onClose(connection.getDelegate());
    }

    public StompServerHandler commitHandler(Handler<ServerFrame> handler) {
        this.delegate.commitHandler(Helper.convertHandler(handler, event -> ServerFrame.newInstance(event)));
        return this;
    }

    public StompServerHandler abortHandler(Handler<ServerFrame> handler) {
        this.delegate.abortHandler(Helper.convertHandler(handler, event -> ServerFrame.newInstance(event)));
        return this;
    }

    public StompServerHandler beginHandler(Handler<ServerFrame> handler) {
        this.delegate.beginHandler(Helper.convertHandler(handler, event -> ServerFrame.newInstance(event)));
        return this;
    }

    public StompServerHandler disconnectHandler(Handler<ServerFrame> handler) {
        this.delegate.disconnectHandler(Helper.convertHandler(handler, event -> ServerFrame.newInstance(event)));
        return this;
    }

    public StompServerHandler ackHandler(Handler<ServerFrame> handler) {
        this.delegate.ackHandler(Helper.convertHandler(handler, event -> ServerFrame.newInstance(event)));
        return this;
    }

    public StompServerHandler nackHandler(Handler<ServerFrame> handler) {
        this.delegate.nackHandler(Helper.convertHandler(handler, event -> ServerFrame.newInstance(event)));
        return this;
    }

    public Single<Boolean> onAuthenticationRequest(StompServerConnection connection, String login, String passcode) {
        Single ret = this.rxOnAuthenticationRequest(connection, login, passcode);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Boolean> rxOnAuthenticationRequest(StompServerConnection connection, String login, String passcode) {
        return AsyncResultSingle.toSingle(() -> this.delegate.onAuthenticationRequest(connection.getDelegate(), login, passcode), __value -> __value);
    }

    public User getUserBySession(String session) {
        User ret = User.newInstance(this.delegate.getUserBySession(session));
        return ret;
    }

    public StompServerHandler authProvider(AuthenticationProvider handler) {
        this.delegate.authProvider(handler.getDelegate());
        return this;
    }

    public List<Destination> getDestinations() {
        List<Destination> ret = this.delegate.getDestinations().stream().map(elt -> Destination.newInstance(elt)).collect(Collectors.toList());
        return ret;
    }

    public Destination getDestination(String destination) {
        Destination ret = Destination.newInstance(this.delegate.getDestination(destination));
        return ret;
    }

    public StompServerHandler onAck(StompServerConnection connection, Frame subscribe, List<Frame> messages) {
        this.delegate.onAck(connection.getDelegate(), subscribe, messages);
        return this;
    }

    public StompServerHandler onNack(StompServerConnection connection, Frame subscribe, List<Frame> messages) {
        this.delegate.onNack(connection.getDelegate(), subscribe, messages);
        return this;
    }

    public StompServerHandler onAckHandler(Handler<Acknowledgement> handler) {
        this.delegate.onAckHandler(Helper.convertHandler(handler, event -> Acknowledgement.newInstance(event)));
        return this;
    }

    public StompServerHandler onNackHandler(Handler<Acknowledgement> handler) {
        this.delegate.onNackHandler(Helper.convertHandler(handler, event -> Acknowledgement.newInstance(event)));
        return this;
    }

    public StompServerHandler pingHandler(Handler<StompServerConnection> handler) {
        this.delegate.pingHandler(Helper.convertHandler(handler, event -> StompServerConnection.newInstance(event)));
        return this;
    }

    public Destination getOrCreateDestination(String destination) {
        Destination ret = Destination.newInstance(this.delegate.getOrCreateDestination(destination));
        return ret;
    }

    public StompServerHandler destinationFactory(DestinationFactory factory) {
        this.delegate.destinationFactory(factory.getDelegate());
        return this;
    }

    public StompServerHandler bridge(BridgeOptions options) {
        this.delegate.bridge(options);
        return this;
    }

    public static StompServerHandler newInstance(io.vertx.ext.stomp.StompServerHandler arg) {
        return arg != null ? new StompServerHandler(arg) : null;
    }
}

