/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.cassandra;

import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.Metadata;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Single;
import io.vertx.cassandra.CassandraClientOptions;
import io.vertx.core.Vertx;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rxjava3.CompletableHelper;
import io.vertx.rxjava3.SingleHelper;
import io.vertx.rxjava3.cassandra.CassandraRowStream;
import io.vertx.rxjava3.cassandra.ResultSet;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import java.util.List;

@RxGen(value=io.vertx.cassandra.CassandraClient.class)
public class CassandraClient
implements RxDelegate {
    public static final TypeArg<CassandraClient> __TYPE_ARG = new TypeArg(obj -> new CassandraClient((io.vertx.cassandra.CassandraClient)obj), CassandraClient::getDelegate);
    private final io.vertx.cassandra.CassandraClient delegate;
    private static final TypeArg<ResultSet> TYPE_ARG_0 = new TypeArg(o1 -> ResultSet.newInstance((io.vertx.cassandra.ResultSet)o1), o1 -> o1.getDelegate());
    private static final TypeArg<CassandraRowStream> TYPE_ARG_1 = new TypeArg(o1 -> CassandraRowStream.newInstance((io.vertx.cassandra.CassandraRowStream)o1), o1 -> o1.getDelegate());
    private static final TypeArg<ResultSet> TYPE_ARG_2 = new TypeArg(o1 -> ResultSet.newInstance((io.vertx.cassandra.ResultSet)o1), o1 -> o1.getDelegate());
    private static final TypeArg<CassandraRowStream> TYPE_ARG_3 = new TypeArg(o1 -> CassandraRowStream.newInstance((io.vertx.cassandra.CassandraRowStream)o1), o1 -> o1.getDelegate());
    public static final String DEFAULT_SHARED_CLIENT_NAME = "DEFAULT";

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CassandraClient that = (CassandraClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public CassandraClient(io.vertx.cassandra.CassandraClient delegate) {
        this.delegate = delegate;
    }

    public CassandraClient(Object delegate) {
        this.delegate = (io.vertx.cassandra.CassandraClient)delegate;
    }

    public io.vertx.cassandra.CassandraClient getDelegate() {
        return this.delegate;
    }

    public static CassandraClient create(io.vertx.rxjava3.core.Vertx vertx) {
        CassandraClient ret = CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static CassandraClient create(io.vertx.rxjava3.core.Vertx vertx, CassandraClientOptions options) {
        CassandraClient ret = CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.create((Vertx)vertx.getDelegate(), (CassandraClientOptions)options));
        return ret;
    }

    public static CassandraClient createShared(io.vertx.rxjava3.core.Vertx vertx) {
        CassandraClient ret = CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.createShared((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static CassandraClient createShared(io.vertx.rxjava3.core.Vertx vertx, String clientName) {
        CassandraClient ret = CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.createShared((Vertx)vertx.getDelegate(), (String)clientName));
        return ret;
    }

    public static CassandraClient createShared(io.vertx.rxjava3.core.Vertx vertx, CassandraClientOptions options) {
        CassandraClient ret = CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.createShared((Vertx)vertx.getDelegate(), (CassandraClientOptions)options));
        return ret;
    }

    public static CassandraClient createShared(io.vertx.rxjava3.core.Vertx vertx, String clientName, CassandraClientOptions options) {
        CassandraClient ret = CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.createShared((Vertx)vertx.getDelegate(), (String)clientName, (CassandraClientOptions)options));
        return ret;
    }

    public boolean isConnected() {
        boolean ret = this.delegate.isConnected();
        return ret;
    }

    public Single<ResultSet> execute(String query) {
        Single ret = this.rxExecute(query);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<ResultSet> rxExecute(String query) {
        return AsyncResultSingle.toSingle(() -> this.delegate.execute(query), __value -> ResultSet.newInstance(__value));
    }

    public Single<CassandraRowStream> queryStream(String sql) {
        Single ret = this.rxQueryStream(sql);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<CassandraRowStream> rxQueryStream(String sql) {
        return AsyncResultSingle.toSingle(() -> this.delegate.queryStream(sql), __value -> CassandraRowStream.newInstance(__value));
    }

    public Completable close() {
        Completable ret = this.rxClose();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.close());
    }

    public Single<List<Row>> executeWithFullFetch(String query) {
        Single ret = this.rxExecuteWithFullFetch(query);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<List<Row>> rxExecuteWithFullFetch(String query) {
        return AsyncResultSingle.toSingle(() -> this.delegate.executeWithFullFetch(query), __value -> __value);
    }

    public Single<List<Row>> executeWithFullFetch(Statement statement) {
        Single ret = this.rxExecuteWithFullFetch(statement);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<List<Row>> rxExecuteWithFullFetch(Statement statement) {
        return AsyncResultSingle.toSingle(() -> this.delegate.executeWithFullFetch(statement), __value -> __value);
    }

    public Single<ResultSet> execute(Statement statement) {
        Single ret = this.rxExecute(statement);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<ResultSet> rxExecute(Statement statement) {
        return AsyncResultSingle.toSingle(() -> this.delegate.execute(statement), __value -> ResultSet.newInstance(__value));
    }

    public Single<PreparedStatement> prepare(String query) {
        Single ret = this.rxPrepare(query);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<PreparedStatement> rxPrepare(String query) {
        return AsyncResultSingle.toSingle(() -> this.delegate.prepare(query), __value -> __value);
    }

    public Single<PreparedStatement> prepare(SimpleStatement statement) {
        Single ret = this.rxPrepare(statement);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<PreparedStatement> rxPrepare(SimpleStatement statement) {
        return AsyncResultSingle.toSingle(() -> this.delegate.prepare(statement), __value -> __value);
    }

    public Single<CassandraRowStream> queryStream(Statement statement) {
        Single ret = this.rxQueryStream(statement);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<CassandraRowStream> rxQueryStream(Statement statement) {
        return AsyncResultSingle.toSingle(() -> this.delegate.queryStream(statement), __value -> CassandraRowStream.newInstance(__value));
    }

    public Single<Metadata> metadata() {
        Single ret = this.rxMetadata();
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Metadata> rxMetadata() {
        return AsyncResultSingle.toSingle(() -> this.delegate.metadata(), __value -> __value);
    }

    public static CassandraClient newInstance(io.vertx.cassandra.CassandraClient arg) {
        return arg != null ? new CassandraClient(arg) : null;
    }
}

