/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.ext.stomp;

import io.reactivex.rxjava3.core.Single;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.stomp.Frame;
import io.vertx.lang.rx.DelegatingHandler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rxjava3.SingleHelper;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import java.util.Map;

@RxGen(value=io.vertx.ext.stomp.StompClientConnection.class)
public class StompClientConnection {
    public static final TypeArg<StompClientConnection> __TYPE_ARG = new TypeArg(obj -> new StompClientConnection((io.vertx.ext.stomp.StompClientConnection)obj), StompClientConnection::getDelegate);
    private final io.vertx.ext.stomp.StompClientConnection delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StompClientConnection that = (StompClientConnection)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public StompClientConnection(io.vertx.ext.stomp.StompClientConnection delegate) {
        this.delegate = delegate;
    }

    public StompClientConnection(Object delegate) {
        this.delegate = (io.vertx.ext.stomp.StompClientConnection)delegate;
    }

    public io.vertx.ext.stomp.StompClientConnection getDelegate() {
        return this.delegate;
    }

    public String session() {
        String ret = this.delegate.session();
        return ret;
    }

    public String version() {
        String ret = this.delegate.version();
        return ret;
    }

    public void close() {
        this.delegate.close();
    }

    public String server() {
        String ret = this.delegate.server();
        return ret;
    }

    public Single<Frame> send(Map<String, String> headers, Buffer body) {
        Single ret = this.rxSend(headers, body);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Frame> rxSend(Map<String, String> headers, Buffer body) {
        return AsyncResultSingle.toSingle(() -> this.delegate.send(headers, body), __value -> __value);
    }

    public Single<Frame> send(String destination, Buffer body) {
        Single ret = this.rxSend(destination, body);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Frame> rxSend(String destination, Buffer body) {
        return AsyncResultSingle.toSingle(() -> this.delegate.send(destination, body), __value -> __value);
    }

    public Single<Frame> send(Frame frame) {
        Single ret = this.rxSend(frame);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Frame> rxSend(Frame frame) {
        return AsyncResultSingle.toSingle(() -> this.delegate.send(frame), __value -> __value);
    }

    public Single<Frame> send(String destination, Map<String, String> headers, Buffer body) {
        Single ret = this.rxSend(destination, headers, body);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Frame> rxSend(String destination, Map<String, String> headers, Buffer body) {
        return AsyncResultSingle.toSingle(() -> this.delegate.send(destination, headers, body), __value -> __value);
    }

    public Single<String> subscribe(String destination, Handler<Frame> handler) {
        Single ret = this.rxSubscribe(destination, handler);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<String> rxSubscribe(String destination, Handler<Frame> handler) {
        return AsyncResultSingle.toSingle(() -> this.delegate.subscribe(destination, handler), __value -> __value);
    }

    public Single<String> subscribe(String destination, Map<String, String> headers, Handler<Frame> handler) {
        Single ret = this.rxSubscribe(destination, headers, handler);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<String> rxSubscribe(String destination, Map<String, String> headers, Handler<Frame> handler) {
        return AsyncResultSingle.toSingle(() -> this.delegate.subscribe(destination, headers, handler), __value -> __value);
    }

    public Single<Frame> unsubscribe(String destination) {
        Single ret = this.rxUnsubscribe(destination);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Frame> rxUnsubscribe(String destination) {
        return AsyncResultSingle.toSingle(() -> this.delegate.unsubscribe(destination), __value -> __value);
    }

    public Single<Frame> unsubscribe(String destination, Map<String, String> headers) {
        Single ret = this.rxUnsubscribe(destination, headers);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Frame> rxUnsubscribe(String destination, Map<String, String> headers) {
        return AsyncResultSingle.toSingle(() -> this.delegate.unsubscribe(destination, headers), __value -> __value);
    }

    public StompClientConnection errorHandler(Handler<Frame> handler) {
        StompClientConnection ret = StompClientConnection.newInstance(this.delegate.errorHandler(handler));
        return ret;
    }

    public StompClientConnection closeHandler(Handler<StompClientConnection> handler) {
        this.delegate.closeHandler((Handler)new DelegatingHandler(handler, event -> StompClientConnection.newInstance(event)));
        return this;
    }

    public StompClientConnection connectionDroppedHandler(Handler<StompClientConnection> handler) {
        this.delegate.connectionDroppedHandler((Handler)new DelegatingHandler(handler, event -> StompClientConnection.newInstance(event)));
        return this;
    }

    public StompClientConnection pingHandler(Handler<StompClientConnection> handler) {
        this.delegate.pingHandler((Handler)new DelegatingHandler(handler, event -> StompClientConnection.newInstance(event)));
        return this;
    }

    public Single<Frame> beginTX(String id) {
        Single ret = this.rxBeginTX(id);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Frame> rxBeginTX(String id) {
        return AsyncResultSingle.toSingle(() -> this.delegate.beginTX(id), __value -> __value);
    }

    public Single<Frame> beginTX(String id, Map<String, String> headers) {
        Single ret = this.rxBeginTX(id, headers);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Frame> rxBeginTX(String id, Map<String, String> headers) {
        return AsyncResultSingle.toSingle(() -> this.delegate.beginTX(id, headers), __value -> __value);
    }

    public Single<Frame> commit(String id) {
        Single ret = this.rxCommit(id);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Frame> rxCommit(String id) {
        return AsyncResultSingle.toSingle(() -> this.delegate.commit(id), __value -> __value);
    }

    public Single<Frame> commit(String id, Map<String, String> headers) {
        Single ret = this.rxCommit(id, headers);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Frame> rxCommit(String id, Map<String, String> headers) {
        return AsyncResultSingle.toSingle(() -> this.delegate.commit(id, headers), __value -> __value);
    }

    public Single<Frame> abort(String id) {
        Single ret = this.rxAbort(id);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Frame> rxAbort(String id) {
        return AsyncResultSingle.toSingle(() -> this.delegate.abort(id), __value -> __value);
    }

    public Single<Frame> abort(String id, Map<String, String> headers) {
        Single ret = this.rxAbort(id, headers);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Frame> rxAbort(String id, Map<String, String> headers) {
        return AsyncResultSingle.toSingle(() -> this.delegate.abort(id, headers), __value -> __value);
    }

    public Single<Frame> disconnect() {
        Single ret = this.rxDisconnect();
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Frame> rxDisconnect() {
        return AsyncResultSingle.toSingle(() -> this.delegate.disconnect(), __value -> __value);
    }

    public Single<Frame> disconnect(Frame frame) {
        Single ret = this.rxDisconnect(frame);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Frame> rxDisconnect(Frame frame) {
        return AsyncResultSingle.toSingle(() -> this.delegate.disconnect(frame), __value -> __value);
    }

    public Single<Frame> ack(String id) {
        Single ret = this.rxAck(id);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Frame> rxAck(String id) {
        return AsyncResultSingle.toSingle(() -> this.delegate.ack(id), __value -> __value);
    }

    public Single<Frame> nack(String id) {
        Single ret = this.rxNack(id);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Frame> rxNack(String id) {
        return AsyncResultSingle.toSingle(() -> this.delegate.nack(id), __value -> __value);
    }

    public Single<Frame> ack(String id, String txId) {
        Single ret = this.rxAck(id, txId);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Frame> rxAck(String id, String txId) {
        return AsyncResultSingle.toSingle(() -> this.delegate.ack(id, txId), __value -> __value);
    }

    public Single<Frame> nack(String id, String txId) {
        Single ret = this.rxNack(id, txId);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Frame> rxNack(String id, String txId) {
        return AsyncResultSingle.toSingle(() -> this.delegate.nack(id, txId), __value -> __value);
    }

    public StompClientConnection receivedFrameHandler(Handler<Frame> handler) {
        this.delegate.receivedFrameHandler(handler);
        return this;
    }

    public StompClientConnection writingFrameHandler(Handler<Frame> handler) {
        this.delegate.writingFrameHandler(handler);
        return this;
    }

    public StompClientConnection exceptionHandler(Handler<Throwable> exceptionHandler) {
        this.delegate.exceptionHandler(exceptionHandler);
        return this;
    }

    public boolean isConnected() {
        boolean ret = this.delegate.isConnected();
        return ret;
    }

    public static StompClientConnection newInstance(io.vertx.ext.stomp.StompClientConnection arg) {
        return arg != null ? new StompClientConnection(arg) : null;
    }
}

