/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.ext.auth.oauth2;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Single;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.oauth2.OAuth2AuthorizationURL;
import io.vertx.ext.auth.oauth2.OAuth2Options;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rxjava3.CompletableHelper;
import io.vertx.rxjava3.SingleHelper;
import io.vertx.rxjava3.ext.auth.User;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.impl.AsyncResultSingle;

@RxGen(value=io.vertx.ext.auth.oauth2.OAuth2Auth.class)
public class OAuth2Auth
extends io.vertx.rxjava3.ext.auth.authentication.AuthenticationProvider {
    public static final TypeArg<OAuth2Auth> __TYPE_ARG = new TypeArg(obj -> new OAuth2Auth((io.vertx.ext.auth.oauth2.OAuth2Auth)obj), OAuth2Auth::getDelegate);
    private final io.vertx.ext.auth.oauth2.OAuth2Auth delegate;
    private static final TypeArg<User> TYPE_ARG_0 = new TypeArg(o1 -> User.newInstance((io.vertx.ext.auth.User)o1), o1 -> o1.getDelegate());

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuth2Auth that = (OAuth2Auth)o;
        return this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public OAuth2Auth(io.vertx.ext.auth.oauth2.OAuth2Auth delegate) {
        super((AuthenticationProvider)delegate);
        this.delegate = delegate;
    }

    public OAuth2Auth(Object delegate) {
        super((AuthenticationProvider)((io.vertx.ext.auth.oauth2.OAuth2Auth)delegate));
        this.delegate = (io.vertx.ext.auth.oauth2.OAuth2Auth)delegate;
    }

    public io.vertx.ext.auth.oauth2.OAuth2Auth getDelegate() {
        return this.delegate;
    }

    public static OAuth2Auth create(io.vertx.rxjava3.core.Vertx vertx) {
        OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.OAuth2Auth.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static OAuth2Auth create(io.vertx.rxjava3.core.Vertx vertx, OAuth2Options config) {
        OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.OAuth2Auth.create((Vertx)vertx.getDelegate(), (OAuth2Options)config));
        return ret;
    }

    public Completable jWKSet() {
        Completable ret = this.rxJWKSet();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxJWKSet() {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.jWKSet());
    }

    public OAuth2Auth missingKeyHandler(Handler<String> handler) {
        this.delegate.missingKeyHandler(handler);
        return this;
    }

    public String authorizeURL(OAuth2AuthorizationURL url) {
        String ret = this.delegate.authorizeURL(url);
        return ret;
    }

    public Single<User> refresh(User user) {
        Single ret = this.rxRefresh(user);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<User> rxRefresh(User user) {
        return AsyncResultSingle.toSingle(() -> this.delegate.refresh(user.getDelegate()), __value -> User.newInstance(__value));
    }

    public Completable revoke(User user, String tokenType) {
        Completable ret = this.rxRevoke(user, tokenType);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxRevoke(User user, String tokenType) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.revoke(user.getDelegate(), tokenType));
    }

    public Completable revoke(User user) {
        Completable ret = this.rxRevoke(user);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxRevoke(User user) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.revoke(user.getDelegate()));
    }

    public Single<JsonObject> userInfo(User user) {
        Single ret = this.rxUserInfo(user);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<JsonObject> rxUserInfo(User user) {
        return AsyncResultSingle.toSingle(() -> this.delegate.userInfo(user.getDelegate()), __value -> __value);
    }

    public String endSessionURL(User user, JsonObject params) {
        String ret = this.delegate.endSessionURL(user.getDelegate(), params);
        return ret;
    }

    public String endSessionURL(User user) {
        String ret = this.delegate.endSessionURL(user.getDelegate());
        return ret;
    }

    public void close() {
        this.delegate.close();
    }

    public static OAuth2Auth newInstance(io.vertx.ext.auth.oauth2.OAuth2Auth arg) {
        return arg != null ? new OAuth2Auth(arg) : null;
    }
}

