/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.core.shareddata;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rxjava3.CompletableHelper;
import io.vertx.rxjava3.MaybeHelper;
import io.vertx.rxjava3.SingleHelper;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@RxGen(value=io.vertx.core.shareddata.AsyncMap.class)
public class AsyncMap<K, V> {
    public static final TypeArg<AsyncMap> __TYPE_ARG = new TypeArg(obj -> new AsyncMap((io.vertx.core.shareddata.AsyncMap)obj), AsyncMap::getDelegate);
    private final io.vertx.core.shareddata.AsyncMap<K, V> delegate;
    public final TypeArg<K> __typeArg_0;
    public final TypeArg<V> __typeArg_1;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AsyncMap that = (AsyncMap)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public AsyncMap(io.vertx.core.shareddata.AsyncMap delegate) {
        this.delegate = delegate;
        this.__typeArg_0 = TypeArg.unknown();
        this.__typeArg_1 = TypeArg.unknown();
    }

    public AsyncMap(Object delegate, TypeArg<K> typeArg_0, TypeArg<V> typeArg_1) {
        this.delegate = (io.vertx.core.shareddata.AsyncMap)delegate;
        this.__typeArg_0 = typeArg_0;
        this.__typeArg_1 = typeArg_1;
    }

    public io.vertx.core.shareddata.AsyncMap getDelegate() {
        return this.delegate;
    }

    public Maybe<V> get(K k) {
        Maybe ret = this.rxGet(k);
        ret = ret.cache();
        ret.subscribe(MaybeHelper.nullObserver());
        return ret;
    }

    public Maybe<V> rxGet(K k) {
        return AsyncResultMaybe.toMaybe(() -> this.delegate.get(this.__typeArg_0.unwrap(k)), __value -> this.__typeArg_1.wrap(__value));
    }

    public Completable put(K k, V v) {
        Completable ret = this.rxPut(k, v);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxPut(K k, V v) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.put(this.__typeArg_0.unwrap(k), this.__typeArg_1.unwrap(v)));
    }

    public Completable put(K k, V v, long ttl) {
        Completable ret = this.rxPut(k, v, ttl);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxPut(K k, V v, long ttl) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.put(this.__typeArg_0.unwrap(k), this.__typeArg_1.unwrap(v), ttl));
    }

    public Maybe<V> putIfAbsent(K k, V v) {
        Maybe ret = this.rxPutIfAbsent(k, v);
        ret = ret.cache();
        ret.subscribe(MaybeHelper.nullObserver());
        return ret;
    }

    public Maybe<V> rxPutIfAbsent(K k, V v) {
        return AsyncResultMaybe.toMaybe(() -> this.delegate.putIfAbsent(this.__typeArg_0.unwrap(k), this.__typeArg_1.unwrap(v)), __value -> this.__typeArg_1.wrap(__value));
    }

    public Maybe<V> putIfAbsent(K k, V v, long ttl) {
        Maybe ret = this.rxPutIfAbsent(k, v, ttl);
        ret = ret.cache();
        ret.subscribe(MaybeHelper.nullObserver());
        return ret;
    }

    public Maybe<V> rxPutIfAbsent(K k, V v, long ttl) {
        return AsyncResultMaybe.toMaybe(() -> this.delegate.putIfAbsent(this.__typeArg_0.unwrap(k), this.__typeArg_1.unwrap(v), ttl), __value -> this.__typeArg_1.wrap(__value));
    }

    public Maybe<V> remove(K k) {
        Maybe ret = this.rxRemove(k);
        ret = ret.cache();
        ret.subscribe(MaybeHelper.nullObserver());
        return ret;
    }

    public Maybe<V> rxRemove(K k) {
        return AsyncResultMaybe.toMaybe(() -> this.delegate.remove(this.__typeArg_0.unwrap(k)), __value -> this.__typeArg_1.wrap(__value));
    }

    public Single<Boolean> removeIfPresent(K k, V v) {
        Single ret = this.rxRemoveIfPresent(k, v);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Boolean> rxRemoveIfPresent(K k, V v) {
        return AsyncResultSingle.toSingle(() -> this.delegate.removeIfPresent(this.__typeArg_0.unwrap(k), this.__typeArg_1.unwrap(v)), __value -> __value);
    }

    public Maybe<V> replace(K k, V v) {
        Maybe ret = this.rxReplace(k, v);
        ret = ret.cache();
        ret.subscribe(MaybeHelper.nullObserver());
        return ret;
    }

    public Maybe<V> rxReplace(K k, V v) {
        return AsyncResultMaybe.toMaybe(() -> this.delegate.replace(this.__typeArg_0.unwrap(k), this.__typeArg_1.unwrap(v)), __value -> this.__typeArg_1.wrap(__value));
    }

    public Maybe<V> replace(K k, V v, long ttl) {
        Maybe ret = this.rxReplace(k, v, ttl);
        ret = ret.cache();
        ret.subscribe(MaybeHelper.nullObserver());
        return ret;
    }

    public Maybe<V> rxReplace(K k, V v, long ttl) {
        return AsyncResultMaybe.toMaybe(() -> this.delegate.replace(this.__typeArg_0.unwrap(k), this.__typeArg_1.unwrap(v), ttl), __value -> this.__typeArg_1.wrap(__value));
    }

    public Single<Boolean> replaceIfPresent(K k, V oldValue, V newValue) {
        Single ret = this.rxReplaceIfPresent(k, oldValue, newValue);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Boolean> rxReplaceIfPresent(K k, V oldValue, V newValue) {
        return AsyncResultSingle.toSingle(() -> this.delegate.replaceIfPresent(this.__typeArg_0.unwrap(k), this.__typeArg_1.unwrap(oldValue), this.__typeArg_1.unwrap(newValue)), __value -> __value);
    }

    public Single<Boolean> replaceIfPresent(K k, V oldValue, V newValue, long ttl) {
        Single ret = this.rxReplaceIfPresent(k, oldValue, newValue, ttl);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Boolean> rxReplaceIfPresent(K k, V oldValue, V newValue, long ttl) {
        return AsyncResultSingle.toSingle(() -> this.delegate.replaceIfPresent(this.__typeArg_0.unwrap(k), this.__typeArg_1.unwrap(oldValue), this.__typeArg_1.unwrap(newValue), ttl), __value -> __value);
    }

    public Completable clear() {
        Completable ret = this.rxClear();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxClear() {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.clear());
    }

    public Single<Integer> size() {
        Single ret = this.rxSize();
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Integer> rxSize() {
        return AsyncResultSingle.toSingle(() -> this.delegate.size(), __value -> __value);
    }

    public Single<Set<K>> keys() {
        Single ret = this.rxKeys();
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Set<K>> rxKeys() {
        return AsyncResultSingle.toSingle(() -> this.delegate.keys(), __value -> __value.stream().map(elt -> this.__typeArg_0.wrap(elt)).collect(Collectors.toSet()));
    }

    public Single<List<V>> values() {
        Single ret = this.rxValues();
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<List<V>> rxValues() {
        return AsyncResultSingle.toSingle(() -> this.delegate.values(), __value -> __value.stream().map(elt -> this.__typeArg_1.wrap(elt)).collect(Collectors.toList()));
    }

    public static <K, V> AsyncMap<K, V> newInstance(io.vertx.core.shareddata.AsyncMap arg) {
        return arg != null ? new AsyncMap<K, V>(arg) : null;
    }

    public static <K, V> AsyncMap<K, V> newInstance(io.vertx.core.shareddata.AsyncMap arg, TypeArg<K> __typeArg_K, TypeArg<V> __typeArg_V) {
        return arg != null ? new AsyncMap<K, V>(arg, __typeArg_K, __typeArg_V) : null;
    }
}

