/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.web.validation.builder;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Builder for a . <br/>
 *
 * For more info look the docs
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.validation.builder.ValidationHandlerBuilder original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.validation.builder.ValidationHandlerBuilder.class)
public class ValidationHandlerBuilder implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ValidationHandlerBuilder that = (ValidationHandlerBuilder) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ValidationHandlerBuilder> __TYPE_ARG = new TypeArg<>(    obj -> new ValidationHandlerBuilder((io.vertx.ext.web.validation.builder.ValidationHandlerBuilder) obj),
    ValidationHandlerBuilder::getDelegate
  );

  private final io.vertx.ext.web.validation.builder.ValidationHandlerBuilder delegate;
  
  public ValidationHandlerBuilder(io.vertx.ext.web.validation.builder.ValidationHandlerBuilder delegate) {
    this.delegate = delegate;
  }

  public ValidationHandlerBuilder(Object delegate) {
    this.delegate = (io.vertx.ext.web.validation.builder.ValidationHandlerBuilder)delegate;
  }

  @Override 
  public io.vertx.ext.web.validation.builder.ValidationHandlerBuilder getDelegate() {
    return delegate;
  }

  public io.vertx.rxjava3.ext.web.validation.builder.ValidationHandlerBuilder queryParameter(io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory parameterProcessor) { 
    delegate.queryParameter(parameterProcessor.getDelegate());
    return this;
  }

  public io.vertx.rxjava3.ext.web.validation.builder.ValidationHandlerBuilder queryParameter(io.vertx.rxjava3.ext.web.validation.builder.ParameterProcessorFactory parameterProcessor) { 
    delegate.queryParameter(parameterProcessor.getDelegate());
    return this;
  }

  public io.vertx.rxjava3.ext.web.validation.builder.ValidationHandlerBuilder pathParameter(io.vertx.rxjava3.ext.web.validation.builder.ParameterProcessorFactory parameterProcessor) { 
    delegate.pathParameter(parameterProcessor.getDelegate());
    return this;
  }

  public io.vertx.rxjava3.ext.web.validation.builder.ValidationHandlerBuilder cookieParameter(io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory parameterProcessor) { 
    delegate.cookieParameter(parameterProcessor.getDelegate());
    return this;
  }

  public io.vertx.rxjava3.ext.web.validation.builder.ValidationHandlerBuilder cookieParameter(io.vertx.rxjava3.ext.web.validation.builder.ParameterProcessorFactory parameterProcessor) { 
    delegate.cookieParameter(parameterProcessor.getDelegate());
    return this;
  }

  public io.vertx.rxjava3.ext.web.validation.builder.ValidationHandlerBuilder headerParameter(io.vertx.rxjava3.ext.web.validation.builder.ParameterProcessorFactory parameterProcessor) { 
    delegate.headerParameter(parameterProcessor.getDelegate());
    return this;
  }

  public io.vertx.rxjava3.ext.web.validation.builder.ValidationHandlerBuilder body(io.vertx.rxjava3.ext.web.validation.builder.BodyProcessorFactory bodyProcessor) { 
    delegate.body(bodyProcessor.getDelegate());
    return this;
  }

  public io.vertx.rxjava3.ext.web.validation.builder.ValidationHandlerBuilder predicate(io.vertx.rxjava3.ext.web.validation.RequestPredicate predicate) { 
    delegate.predicate(predicate.getDelegate());
    return this;
  }

  public static io.vertx.rxjava3.ext.web.validation.builder.ValidationHandlerBuilder create(io.vertx.rxjava3.json.schema.SchemaParser parser) { 
    io.vertx.rxjava3.ext.web.validation.builder.ValidationHandlerBuilder ret = io.vertx.rxjava3.ext.web.validation.builder.ValidationHandlerBuilder.newInstance((io.vertx.ext.web.validation.builder.ValidationHandlerBuilder)io.vertx.ext.web.validation.builder.ValidationHandlerBuilder.create(parser.getDelegate()));
    return ret;
  }

  /**
   * Add a parameter given the location and the processor
   * @param location 
   * @param processor 
   * @return 
   */
  public io.vertx.rxjava3.ext.web.validation.builder.ValidationHandlerBuilder parameter(io.vertx.ext.web.validation.impl.ParameterLocation location, io.vertx.ext.web.validation.impl.parameter.ParameterProcessor processor) { 
    delegate.parameter(location, processor);
    return this;
  }

  public io.vertx.rxjava3.ext.web.validation.builder.ValidationHandlerBuilder body(io.vertx.ext.web.validation.impl.body.BodyProcessor bodyProcessor) { 
    delegate.body(bodyProcessor);
    return this;
  }

  /**
   * Build the  from this builder
   * @return 
   */
  public io.vertx.rxjava3.ext.web.validation.ValidationHandler build() { 
    io.vertx.rxjava3.ext.web.validation.ValidationHandler ret = io.vertx.rxjava3.ext.web.validation.ValidationHandler.newInstance((io.vertx.ext.web.validation.ValidationHandler)delegate.build());
    return ret;
  }

  public static ValidationHandlerBuilder newInstance(io.vertx.ext.web.validation.builder.ValidationHandlerBuilder arg) {
    return arg != null ? new ValidationHandlerBuilder(arg) : null;
  }

}
