/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.mail;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represent a mail attachment that can be used in a MailMessage.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.mail.MailAttachment original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.mail.MailAttachment.class)
public class MailAttachment implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MailAttachment that = (MailAttachment) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MailAttachment> __TYPE_ARG = new TypeArg<>(    obj -> new MailAttachment((io.vertx.ext.mail.MailAttachment) obj),
    MailAttachment::getDelegate
  );

  private final io.vertx.ext.mail.MailAttachment delegate;
  
  public MailAttachment(io.vertx.ext.mail.MailAttachment delegate) {
    this.delegate = delegate;
  }

  public MailAttachment(Object delegate) {
    this.delegate = (io.vertx.ext.mail.MailAttachment)delegate;
  }

  @Override 
  public io.vertx.ext.mail.MailAttachment getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.rxjava3.core.buffer.Buffer> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava3.core.buffer.Buffer>(o1 -> io.vertx.rxjava3.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());

  /**
   * construct an empty MailAttachment object that can be filled with the
   * setters
   * @return 
   */
  public static io.vertx.rxjava3.ext.mail.MailAttachment create() { 
    io.vertx.rxjava3.ext.mail.MailAttachment ret = io.vertx.rxjava3.ext.mail.MailAttachment.newInstance((io.vertx.ext.mail.MailAttachment)io.vertx.ext.mail.MailAttachment.create());
    return ret;
  }

  /**
   * create a MailAttachment object from a JsonObject representation
   * @param json object to be copied
   * @return 
   */
  public static io.vertx.rxjava3.ext.mail.MailAttachment create(io.vertx.core.json.JsonObject json) { 
    io.vertx.rxjava3.ext.mail.MailAttachment ret = io.vertx.rxjava3.ext.mail.MailAttachment.newInstance((io.vertx.ext.mail.MailAttachment)io.vertx.ext.mail.MailAttachment.create(json));
    return ret;
  }

  /**
   * create a copy of a MailAttachment object
   * @param other object to be copied
   * @return 
   */
  public static io.vertx.rxjava3.ext.mail.MailAttachment create(io.vertx.rxjava3.ext.mail.MailAttachment other) { 
    io.vertx.rxjava3.ext.mail.MailAttachment ret = io.vertx.rxjava3.ext.mail.MailAttachment.newInstance((io.vertx.ext.mail.MailAttachment)io.vertx.ext.mail.MailAttachment.create(other.getDelegate()));
    return ret;
  }

  /**
   * get the data
   * @return the data
   */
  public io.vertx.rxjava3.core.buffer.Buffer getData() { 
    io.vertx.rxjava3.core.buffer.Buffer ret = io.vertx.rxjava3.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)delegate.getData());
    return ret;
  }

  /**
   * set the data
   * @param data Buffer of bytes to be used at attachment
   * @return this to be able to use it fluently
   */
  public io.vertx.rxjava3.ext.mail.MailAttachment setData(io.vertx.rxjava3.core.buffer.Buffer data) { 
    delegate.setData(data.getDelegate());
    return this;
  }

  /**
   * Gets the data stream.
   * @return the data stream
   */
  public io.vertx.rxjava3.core.streams.ReadStream<io.vertx.rxjava3.core.buffer.Buffer> getStream() { 
    io.vertx.rxjava3.core.streams.ReadStream<io.vertx.rxjava3.core.buffer.Buffer> ret = io.vertx.rxjava3.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.getStream(), TYPE_ARG_0);
    return ret;
  }

  /**
   * Sets the data stream.
   * @param stream data stream to be used at attachment
   * @return this to be able to use it fluently
   */
  public io.vertx.rxjava3.ext.mail.MailAttachment setStream(io.reactivex.rxjava3.core.Flowable<io.vertx.rxjava3.core.buffer.Buffer> stream) { 
    delegate.setStream(io.vertx.rxjava3.impl.ReadStreamSubscriber.asReadStream(stream, obj -> obj.getDelegate()).resume());
    return this;
  }

  /**
   * Gets the size of the attachment.
   * @return the size of the attachment
   */
  public int getSize() { 
    int ret = delegate.getSize();
    return ret;
  }

  /**
   * Sets the size of the attachment.
   *<p>
   * It is needed when using ReadStream for the MailAttachement.
   *</p>
   * @param size the size of the attachment
   * @return this to be able to use it fluently
   */
  public io.vertx.rxjava3.ext.mail.MailAttachment setSize(int size) { 
    delegate.setSize(size);
    return this;
  }

  /**
   * get the name
   * @return the name
   */
  public java.lang.String getName() { 
    java.lang.String ret = delegate.getName();
    return ret;
  }

  /**
   * set the name
   * @param name name of the attachment file
   * @return this to be able to use it fluently <p> name is the descriptive filename that will be put into the mail i.e. usually a local filename without path this can be set to "" to omit the filename attribute
   */
  public io.vertx.rxjava3.ext.mail.MailAttachment setName(java.lang.String name) { 
    delegate.setName(name);
    return this;
  }

  /**
   * get the Content-Type
   * @return the contentType
   */
  public java.lang.String getContentType() { 
    java.lang.String ret = delegate.getContentType();
    return ret;
  }

  /**
   * set the Content-Type
   * @param contentType the contentType
   * @return this to be able to use it fluently
   */
  public io.vertx.rxjava3.ext.mail.MailAttachment setContentType(java.lang.String contentType) { 
    delegate.setContentType(contentType);
    return this;
  }

  /**
   * get the disposition field
   * @return the disposition
   */
  public java.lang.String getDisposition() { 
    java.lang.String ret = delegate.getDisposition();
    return ret;
  }

  /**
   * set the disposition field to be used in the attachment
   * @param disposition the disposition
   * @return this to be able to use it fluently
   */
  public io.vertx.rxjava3.ext.mail.MailAttachment setDisposition(java.lang.String disposition) { 
    delegate.setDisposition(disposition);
    return this;
  }

  /**
   * get the description field
   * @return the description
   */
  public java.lang.String getDescription() { 
    java.lang.String ret = delegate.getDescription();
    return ret;
  }

  /**
   * set the description field to be used in the attachment
   * @param description the description
   * @return this to be able to use it fluently
   */
  public io.vertx.rxjava3.ext.mail.MailAttachment setDescription(java.lang.String description) { 
    delegate.setDescription(description);
    return this;
  }

  /**
   * get the Content-ID field
   * @return the content id
   */
  public java.lang.String getContentId() { 
    java.lang.String ret = delegate.getContentId();
    return ret;
  }

  /**
   * set the Content-ID field to be used in the attachment
   * @param contentId the content id
   * @return this to be able to use it fluently
   */
  public io.vertx.rxjava3.ext.mail.MailAttachment setContentId(java.lang.String contentId) { 
    delegate.setContentId(contentId);
    return this;
  }

  /**
   * Add an header to this attachment.
   * @param key the header key
   * @param value the header value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.ext.mail.MailAttachment addHeader(java.lang.String key, java.lang.String value) { 
    delegate.addHeader(key, value);
    return this;
  }

  /**
   * Get the headers to be added for this attachment.
   * @return the headers
   */
  public io.vertx.rxjava3.core.MultiMap getHeaders() { 
    io.vertx.rxjava3.core.MultiMap ret = io.vertx.rxjava3.core.MultiMap.newInstance((io.vertx.core.MultiMap)delegate.getHeaders());
    return ret;
  }

  /**
   * Set the headers to be added for this attachment.
   * @param headers the headers to be added
   * @return this to be able to use it fluently
   */
  public io.vertx.rxjava3.ext.mail.MailAttachment setHeaders(io.vertx.rxjava3.core.MultiMap headers) { 
    delegate.setHeaders(headers.getDelegate());
    return this;
  }

  /**
   * convert this object to JSON representation
   * @return the JSON object
   */
  public io.vertx.core.json.JsonObject toJson() { 
    io.vertx.core.json.JsonObject ret = delegate.toJson();
    return ret;
  }

  public static MailAttachment newInstance(io.vertx.ext.mail.MailAttachment arg) {
    return arg != null ? new MailAttachment(arg) : null;
  }

}
