/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.auth.prng;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A secure non blocking random number generator isolated to the current context. The PRNG is bound to the vert.x
 * context and setup to close when the context shuts down.
 * <p>
 * When applicable, use of VertxContextPRNG rather than create new PRNG objects is helpful to keep the system entropy
 * usage to the minimum avoiding potential blocking across the application.
 * <p>
 * The use of VertxContextPRNG is particularly appropriate when multiple handlers use random numbers.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.prng.VertxContextPRNG original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.prng.VertxContextPRNG.class)
public class VertxContextPRNG implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    VertxContextPRNG that = (VertxContextPRNG) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<VertxContextPRNG> __TYPE_ARG = new TypeArg<>(    obj -> new VertxContextPRNG((io.vertx.ext.auth.prng.VertxContextPRNG) obj),
    VertxContextPRNG::getDelegate
  );

  private final io.vertx.ext.auth.prng.VertxContextPRNG delegate;
  
  public VertxContextPRNG(io.vertx.ext.auth.prng.VertxContextPRNG delegate) {
    this.delegate = delegate;
  }

  public VertxContextPRNG(Object delegate) {
    this.delegate = (io.vertx.ext.auth.prng.VertxContextPRNG)delegate;
  }

  @Override 
  public io.vertx.ext.auth.prng.VertxContextPRNG getDelegate() {
    return delegate;
  }

  /**
   * Get or create a secure non blocking random number generator using the current vert.x context. If there is no
   * current context (i.e.: not running on the eventloop) then a {@link java.lang.IllegalStateException} is thrown.
   *
   * Note, if a context isn't allowed to be used, for example, exceptions are thrown on getting and putting data,
   * the VertxContextPRNG falls back to instantiate a new instance of the PRNG per call.
   * @return A secure non blocking random number generator.
   */
  public static io.vertx.rxjava3.ext.auth.prng.VertxContextPRNG current() { 
    io.vertx.rxjava3.ext.auth.prng.VertxContextPRNG ret = io.vertx.rxjava3.ext.auth.prng.VertxContextPRNG.newInstance((io.vertx.ext.auth.prng.VertxContextPRNG)io.vertx.ext.auth.prng.VertxContextPRNG.current());
    return ret;
  }

  /**
   * Get or create a secure non blocking random number generator using the current vert.x instance. Since the context
   * might be different this method will attempt to use the current context first if available and then fall back to
   * create a new instance of the PRNG.
   *
   * Note, if a context isn't allowed to be used, for example, exceptions are thrown on getting and putting data,
   * the VertxContextPRNG falls back to instantiate a new instance of the PRNG per call.
   * @param vertx a Vert.x instance.
   * @return A secure non blocking random number generator.
   */
  public static io.vertx.rxjava3.ext.auth.prng.VertxContextPRNG current(io.vertx.rxjava3.core.Vertx vertx) { 
    io.vertx.rxjava3.ext.auth.prng.VertxContextPRNG ret = io.vertx.rxjava3.ext.auth.prng.VertxContextPRNG.newInstance((io.vertx.ext.auth.prng.VertxContextPRNG)io.vertx.ext.auth.prng.VertxContextPRNG.current(vertx.getDelegate()));
    return ret;
  }

  /**
   * stop seeding the PRNG
   */
  public void close() { 
    delegate.close();
  }

  /**
   * Returns a Base64 url encoded String of random data with the given length. The length parameter refers to the length
   * of the String before the encoding step.
   * @param length the desired string length before Base64 encoding.
   * @return A base 64 encoded string.
   */
  public java.lang.String nextString(int length) { 
    java.lang.String ret = delegate.nextString(length);
    return ret;
  }

  /**
   * Returns a secure random int
   * @return random int.
   */
  public int nextInt() { 
    int ret = delegate.nextInt();
    return ret;
  }

  /**
   * Returns a secure random int, between 0 (inclusive) and the specified bound (exclusive).
   * @param bound the upper bound (exclusive), which must be positive.
   * @return random int.
   */
  public int nextInt(int bound) { 
    int ret = delegate.nextInt(bound);
    return ret;
  }

  /**
   * Returns a secure random boolean
   * @return random boolean.
   */
  public boolean nextBoolean() { 
    boolean ret = delegate.nextBoolean();
    return ret;
  }

  /**
   * Returns a secure random long
   * @return random long.
   */
  public long nextLong() { 
    long ret = delegate.nextLong();
    return ret;
  }

  /**
   * Returns a secure random float value. The value is uniformly distributed between 0.0 and 1.0
   * @return random float.
   */
  public float nextFloat() { 
    float ret = delegate.nextFloat();
    return ret;
  }

  /**
   * Returns a secure random double value. The value is uniformly distributed between 0.0 and 1.0
   * @return random double.
   */
  public double nextDouble() { 
    double ret = delegate.nextDouble();
    return ret;
  }

  /**
   * Returns a secure random double value. The value is Gaussian ("normally") distributed
   * with mean 0.0 and standard deviation 1.0
   * @return random double.
   */
  public double nextGaussian() { 
    double ret = delegate.nextGaussian();
    return ret;
  }

  /**
   * Fills the given byte array with random bytes.
   * @param bytes a byte array.
   */
  public void nextBytes(byte[] bytes) { 
    delegate.nextBytes(bytes);
  }

  public static VertxContextPRNG newInstance(io.vertx.ext.auth.prng.VertxContextPRNG arg) {
    return arg != null ? new VertxContextPRNG(arg) : null;
  }

}
