/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.auth.mongo;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Determines how the hashing is computed in the implementation You can implement this to provide a different hashing
 * strategy to the default.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.mongo.HashStrategy original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.mongo.HashStrategy.class)
@Deprecated()
public class HashStrategy implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HashStrategy that = (HashStrategy) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<HashStrategy> __TYPE_ARG = new TypeArg<>(    obj -> new HashStrategy((io.vertx.ext.auth.mongo.HashStrategy) obj),
    HashStrategy::getDelegate
  );

  private final io.vertx.ext.auth.mongo.HashStrategy delegate;
  
  public HashStrategy(io.vertx.ext.auth.mongo.HashStrategy delegate) {
    this.delegate = delegate;
  }

  public HashStrategy(Object delegate) {
    this.delegate = (io.vertx.ext.auth.mongo.HashStrategy)delegate;
  }

  @Override 
  public io.vertx.ext.auth.mongo.HashStrategy getDelegate() {
    return delegate;
  }

  /**
   * Compute the hashed password given the unhashed password and the user
   * @param password the unhashed password
   * @param user the user to get the salt for. This paramter is needed, if the  is declared to be used
   * @return the hashed password
   */
  @Deprecated()
  public java.lang.String computeHash(java.lang.String password, io.vertx.rxjava3.ext.auth.User user) { 
    java.lang.String ret = delegate.computeHash(password, user.getDelegate());
    return ret;
  }

  /**
   * Retrieve the password from the user, or as clear text or as hashed version, depending on the definition
   * @param user the user to get the stored password for
   * @return the password, either as hashed version or as cleartext, depending on the preferences
   */
  @Deprecated()
  public java.lang.String getStoredPwd(io.vertx.rxjava3.ext.auth.User user) { 
    java.lang.String ret = delegate.getStoredPwd(user.getDelegate());
    return ret;
  }

  /**
   * Retrieve the salt. The source of the salt can be the external salt or the propriate column of the given user,
   * depending on the defined {@link io.vertx.ext.auth.mongo.HashSaltStyle}
   * @param user the user to get the salt for. This paramter is needed, if the  is declared to be used
   * @return null in case of  the salt of the user or a defined external salt
   */
  @Deprecated()
  public java.lang.String getSalt(io.vertx.rxjava3.ext.auth.User user) { 
    java.lang.String ret = delegate.getSalt(user.getDelegate());
    return ret;
  }

  /**
   * Set an external salt. This method should be used in case of 
   * @param salt the salt, which shall be used
   */
  @Deprecated()
  public void setExternalSalt(java.lang.String salt) { 
    delegate.setExternalSalt(salt);
  }

  /**
   * Set the saltstyle as defined by {@link io.vertx.ext.auth.mongo.HashSaltStyle}.
   * @param saltStyle the {@link io.vertx.ext.auth.mongo.HashSaltStyle} to be used
   */
  @Deprecated()
  public void setSaltStyle(io.vertx.ext.auth.mongo.HashSaltStyle saltStyle) { 
    delegate.setSaltStyle(saltStyle);
  }

  /**
   * Get the defined {@link io.vertx.ext.auth.mongo.HashSaltStyle} of the current instance
   * @return the saltStyle
   */
  @Deprecated()
  public io.vertx.ext.auth.mongo.HashSaltStyle getSaltStyle() { 
    io.vertx.ext.auth.mongo.HashSaltStyle ret = delegate.getSaltStyle();
    return ret;
  }

  /**
   * Allows the selection of the hashing algorithm.
   * @param algorithm the choosen algorithm
   */
  @Deprecated()
  public void setAlgorithm(io.vertx.ext.auth.mongo.HashAlgorithm algorithm) { 
    delegate.setAlgorithm(algorithm);
  }

  public static HashStrategy newInstance(io.vertx.ext.auth.mongo.HashStrategy arg) {
    return arg != null ? new HashStrategy(arg) : null;
  }

}
