/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.auth.authorization;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Allows to perform a logical 'not' of the specified authorization
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.authorization.NotAuthorization original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.authorization.NotAuthorization.class)
public class NotAuthorization extends io.vertx.rxjava3.ext.auth.authorization.Authorization implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NotAuthorization that = (NotAuthorization) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<NotAuthorization> __TYPE_ARG = new TypeArg<>(    obj -> new NotAuthorization((io.vertx.ext.auth.authorization.NotAuthorization) obj),
    NotAuthorization::getDelegate
  );

  private final io.vertx.ext.auth.authorization.NotAuthorization delegate;
  
  public NotAuthorization(io.vertx.ext.auth.authorization.NotAuthorization delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public NotAuthorization(Object delegate) {
    super((io.vertx.ext.auth.authorization.NotAuthorization)delegate);
    this.delegate = (io.vertx.ext.auth.authorization.NotAuthorization)delegate;
  }

  @Override 
  public io.vertx.ext.auth.authorization.NotAuthorization getDelegate() {
    return delegate;
  }

  public static io.vertx.rxjava3.ext.auth.authorization.NotAuthorization create(io.vertx.rxjava3.ext.auth.authorization.Authorization authorization) { 
    io.vertx.rxjava3.ext.auth.authorization.NotAuthorization ret = io.vertx.rxjava3.ext.auth.authorization.NotAuthorization.newInstance((io.vertx.ext.auth.authorization.NotAuthorization)io.vertx.ext.auth.authorization.NotAuthorization.create(authorization.getDelegate()));
    return ret;
  }

  public io.vertx.rxjava3.ext.auth.authorization.Authorization getAuthorization() { 
    io.vertx.rxjava3.ext.auth.authorization.Authorization ret = io.vertx.rxjava3.ext.auth.authorization.Authorization.newInstance((io.vertx.ext.auth.authorization.Authorization)delegate.getAuthorization());
    return ret;
  }

  public static NotAuthorization newInstance(io.vertx.ext.auth.authorization.NotAuthorization arg) {
    return arg != null ? new NotAuthorization(arg) : null;
  }

}
