/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.httpproxy;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A {@link io.vertx.rxjava3.httpproxy.HttpProxy} interceptor.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.httpproxy.ProxyInterceptor original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.httpproxy.ProxyInterceptor.class)
public interface ProxyInterceptor extends RxDelegate {

  @Override 
  io.vertx.httpproxy.ProxyInterceptor getDelegate();

  /**
   * Handle the proxy request at the stage of this interceptor.
   * @param context the proxy context
   * @return when the request has actually been sent to the origin
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.httpproxy.ProxyResponse> handleProxyRequest(io.vertx.rxjava3.httpproxy.ProxyContext context);

  /**
   * Handle the proxy request at the stage of this interceptor.
   * @param context the proxy context
   * @return when the request has actually been sent to the origin
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.httpproxy.ProxyResponse> rxHandleProxyRequest(io.vertx.rxjava3.httpproxy.ProxyContext context);

  /**
   * Handle the proxy response at the stage of this interceptor.
   * @param context the proxy context
   * @return when the response has actually been sent to the user-agent
   */
  public io.reactivex.rxjava3.core.Completable handleProxyResponse(io.vertx.rxjava3.httpproxy.ProxyContext context);

  /**
   * Handle the proxy response at the stage of this interceptor.
   * @param context the proxy context
   * @return when the response has actually been sent to the user-agent
   */
  public io.reactivex.rxjava3.core.Completable rxHandleProxyResponse(io.vertx.rxjava3.httpproxy.ProxyContext context);

  public static ProxyInterceptor newInstance(io.vertx.httpproxy.ProxyInterceptor arg) {
    return arg != null ? new ProxyInterceptorImpl(arg) : null;
  }

}

class ProxyInterceptorImpl implements ProxyInterceptor {
  private final io.vertx.httpproxy.ProxyInterceptor delegate;
  
  public ProxyInterceptorImpl(io.vertx.httpproxy.ProxyInterceptor delegate) {
    this.delegate = delegate;
  }

  public ProxyInterceptorImpl(Object delegate) {
    this.delegate = (io.vertx.httpproxy.ProxyInterceptor)delegate;
  }

  @Override 
  public io.vertx.httpproxy.ProxyInterceptor getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.rxjava3.httpproxy.ProxyResponse> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava3.httpproxy.ProxyResponse>(o1 -> io.vertx.rxjava3.httpproxy.ProxyResponse.newInstance((io.vertx.httpproxy.ProxyResponse)o1), o1 -> o1.getDelegate());

  /**
   * Handle the proxy request at the stage of this interceptor.
   * @param context the proxy context
   * @return when the request has actually been sent to the origin
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.httpproxy.ProxyResponse> handleProxyRequest(io.vertx.rxjava3.httpproxy.ProxyContext context) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.httpproxy.ProxyResponse> ret = rxHandleProxyRequest(context);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Handle the proxy request at the stage of this interceptor.
   * @param context the proxy context
   * @return when the request has actually been sent to the origin
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.httpproxy.ProxyResponse> rxHandleProxyRequest(io.vertx.rxjava3.httpproxy.ProxyContext context) { 
    return AsyncResultSingle.toSingle(delegate.handleProxyRequest(context.getDelegate()), __value -> io.vertx.rxjava3.httpproxy.ProxyResponse.newInstance((io.vertx.httpproxy.ProxyResponse)__value));
  }

  /**
   * Handle the proxy response at the stage of this interceptor.
   * @param context the proxy context
   * @return when the response has actually been sent to the user-agent
   */
  public io.reactivex.rxjava3.core.Completable handleProxyResponse(io.vertx.rxjava3.httpproxy.ProxyContext context) { 
    io.reactivex.rxjava3.core.Completable ret = rxHandleProxyResponse(context);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Handle the proxy response at the stage of this interceptor.
   * @param context the proxy context
   * @return when the response has actually been sent to the user-agent
   */
  public io.reactivex.rxjava3.core.Completable rxHandleProxyResponse(io.vertx.rxjava3.httpproxy.ProxyContext context) { 
    return AsyncResultCompletable.toCompletable(delegate.handleProxyResponse(context.getDelegate()));
  }

}
