/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.web.openapi.router;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;


@RxGen(io.vertx.ext.web.openapi.router.RequestExtractor.class)
public class RequestExtractor implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RequestExtractor that = (RequestExtractor) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<RequestExtractor> __TYPE_ARG = new TypeArg<>(    obj -> new RequestExtractor((io.vertx.ext.web.openapi.router.RequestExtractor) obj),
    RequestExtractor::getDelegate
  );

  private final io.vertx.ext.web.openapi.router.RequestExtractor delegate;
  
  public RequestExtractor(io.vertx.ext.web.openapi.router.RequestExtractor delegate) {
    this.delegate = delegate;
  }

  public RequestExtractor(Object delegate) {
    this.delegate = (io.vertx.ext.web.openapi.router.RequestExtractor)delegate;
  }

  @Override 
  public io.vertx.ext.web.openapi.router.RequestExtractor getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.rxjava3.openapi.validation.ValidatableRequest> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava3.openapi.validation.ValidatableRequest>(o1 -> io.vertx.rxjava3.openapi.validation.ValidatableRequest.newInstance((io.vertx.openapi.validation.ValidatableRequest)o1), o1 -> o1.getDelegate());

  /**
   * Extracts and transforms the parameters and the body of an incoming request into a 
   * that can be validated by the {@link io.vertx.rxjava3.openapi.validation.RequestValidator}.
   * @param routingContext The routing context of the incoming request.
   * @param operation The operation of the related request.
   * @return A  holding the .
   */
  public io.vertx.core.Future<io.vertx.rxjava3.openapi.validation.ValidatableRequest> extractValidatableRequest(io.vertx.rxjava3.ext.web.RoutingContext routingContext, io.vertx.rxjava3.openapi.contract.Operation operation) { 
    io.vertx.core.Future<io.vertx.rxjava3.openapi.validation.ValidatableRequest> ret = delegate.extractValidatableRequest(routingContext.getDelegate(), operation.getDelegate()).map(val -> io.vertx.rxjava3.openapi.validation.ValidatableRequest.newInstance((io.vertx.openapi.validation.ValidatableRequest)val));
    return ret;
  }

  /**
   * @return a RequestExtractor that works in case that a BodyHandler was applied to the related route.
   */
  public static io.vertx.rxjava3.ext.web.openapi.router.RequestExtractor withBodyHandler() { 
    io.vertx.rxjava3.ext.web.openapi.router.RequestExtractor ret = io.vertx.rxjava3.ext.web.openapi.router.RequestExtractor.newInstance((io.vertx.ext.web.openapi.router.RequestExtractor)io.vertx.ext.web.openapi.router.RequestExtractor.withBodyHandler());
    return ret;
  }

  public static RequestExtractor newInstance(io.vertx.ext.web.openapi.router.RequestExtractor arg) {
    return arg != null ? new RequestExtractor(arg) : null;
  }

}
