/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.core.http;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A server WebSocket handshake, allows to control acceptance or rejection of a WebSocket.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.ServerWebSocketHandshake original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.http.ServerWebSocketHandshake.class)
public class ServerWebSocketHandshake implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ServerWebSocketHandshake that = (ServerWebSocketHandshake) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ServerWebSocketHandshake> __TYPE_ARG = new TypeArg<>(    obj -> new ServerWebSocketHandshake((io.vertx.core.http.ServerWebSocketHandshake) obj),
    ServerWebSocketHandshake::getDelegate
  );

  private final io.vertx.core.http.ServerWebSocketHandshake delegate;
  
  public ServerWebSocketHandshake(io.vertx.core.http.ServerWebSocketHandshake delegate) {
    this.delegate = delegate;
  }

  public ServerWebSocketHandshake(Object delegate) {
    this.delegate = (io.vertx.core.http.ServerWebSocketHandshake)delegate;
  }

  @Override 
  public io.vertx.core.http.ServerWebSocketHandshake getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.rxjava3.core.http.ServerWebSocket> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava3.core.http.ServerWebSocket>(o1 -> io.vertx.rxjava3.core.http.ServerWebSocket.newInstance((io.vertx.core.http.ServerWebSocket)o1), o1 -> o1.getDelegate());

  /**
   *  Returns the HTTP headers.
   * @return the headers
   */
  public io.vertx.rxjava3.core.MultiMap headers() { 
    io.vertx.rxjava3.core.MultiMap ret = io.vertx.rxjava3.core.MultiMap.newInstance((io.vertx.core.MultiMap)delegate.headers());
    return ret;
  }

  /**
   * @return the WebSocket handshake scheme
   */
  public java.lang.String scheme() { 
    java.lang.String ret = delegate.scheme();
    return ret;
  }

  /**
   * @return the WebSocket handshake authority
   */
  public io.vertx.rxjava3.core.net.HostAndPort authority() { 
    io.vertx.rxjava3.core.net.HostAndPort ret = io.vertx.rxjava3.core.net.HostAndPort.newInstance((io.vertx.core.net.HostAndPort)delegate.authority());
    return ret;
  }

  public java.lang.String uri() { 
    java.lang.String ret = delegate.uri();
    return ret;
  }

  /**
   * @return the WebSocket handshake path.
   */
  public java.lang.String path() { 
    java.lang.String ret = delegate.path();
    return ret;
  }

  /**
   * @return the WebSocket handshake query string.
   */
  public java.lang.String query() { 
    java.lang.String ret = delegate.query();
    return ret;
  }

  /**
   * Accept the WebSocket and terminate the WebSocket handshake.
   * <p/>
   * This method should be called from the WebSocket handler to explicitly accept the WebSocket and
   * terminate the WebSocket handshake.
   * @return 
   */
  public io.vertx.core.Future<io.vertx.rxjava3.core.http.ServerWebSocket> accept() { 
    io.vertx.core.Future<io.vertx.rxjava3.core.http.ServerWebSocket> ret = delegate.accept().map(val -> io.vertx.rxjava3.core.http.ServerWebSocket.newInstance((io.vertx.core.http.ServerWebSocket)val));
    return ret;
  }

  /**
   * Reject the WebSocket.
   * <p>
   * Calling this method from the WebSocket handler when it is first passed to you gives you the opportunity to reject
   * the WebSocket, which will cause the WebSocket handshake to fail by returning
   * a  response code.
   * <p>
   * You might use this method, if for example you only want to accept WebSockets with a particular path.
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> reject() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.reject().map(val -> val);
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.core.http.ServerWebSocketHandshake#reject} but with a <code>status</code>.
   * @param status 
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> reject(int status) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.reject(status).map(val -> val);
    return ret;
  }

  /**
   * @return the remote address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket). If <code>useProxyProtocol</code> is set to <code>true</code>, the address returned will be of the actual connecting client.
   */
  public io.vertx.rxjava3.core.net.SocketAddress remoteAddress() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.rxjava3.core.net.SocketAddress ret = io.vertx.rxjava3.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)delegate.remoteAddress());
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the local address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket) If <code>useProxyProtocol</code> is set to <code>true</code>, the address returned will be of the proxy.
   */
  public io.vertx.rxjava3.core.net.SocketAddress localAddress() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.rxjava3.core.net.SocketAddress ret = io.vertx.rxjava3.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)delegate.localAddress());
    cached_1 = ret;
    return ret;
  }

  /**
   * @return true if this {@link io.vertx.rxjava3.core.http.HttpConnection} is encrypted via SSL/TLS.
   */
  public boolean isSsl() { 
    boolean ret = delegate.isSsl();
    return ret;
  }

  /**
   * @return SSLSession associated with the underlying socket. Returns null if connection is not SSL.
   */
  public javax.net.ssl.SSLSession sslSession() { 
    javax.net.ssl.SSLSession ret = delegate.sslSession();
    return ret;
  }

  private io.vertx.rxjava3.core.net.SocketAddress cached_0;
  private io.vertx.rxjava3.core.net.SocketAddress cached_1;
  public static ServerWebSocketHandshake newInstance(io.vertx.core.http.ServerWebSocketHandshake arg) {
    return arg != null ? new ServerWebSocketHandshake(arg) : null;
  }

}
