/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.servicediscovery;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Once a consumer has chosen a service, it builds a {@link io.vertx.rxjava3.servicediscovery.ServiceReference} managing the binding with the chosen
 * service provider.
 * <p>
 * The reference lets the consumer:
 * * access the service (via a proxy or a client) with the {@link io.vertx.rxjava3.servicediscovery.ServiceReference#get} method
 * * release the reference - so the binding between the consumer and the provider is removed
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.servicediscovery.ServiceReference original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.servicediscovery.ServiceReference.class)
public class ServiceReference implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ServiceReference that = (ServiceReference) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ServiceReference> __TYPE_ARG = new TypeArg<>(    obj -> new ServiceReference((io.vertx.servicediscovery.ServiceReference) obj),
    ServiceReference::getDelegate
  );

  private final io.vertx.servicediscovery.ServiceReference delegate;
  
  public ServiceReference(io.vertx.servicediscovery.ServiceReference delegate) {
    this.delegate = delegate;
  }

  public ServiceReference(Object delegate) {
    this.delegate = (io.vertx.servicediscovery.ServiceReference)delegate;
  }

  @Override 
  public io.vertx.servicediscovery.ServiceReference getDelegate() {
    return delegate;
  }

  /**
   * @return the service record.
   */
  public io.vertx.servicediscovery.Record record() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.servicediscovery.Record ret = delegate.record();
    cached_0 = ret;
    return ret;
  }

  /**
   * Gets the object to access the service. It can be a proxy, a client or whatever object. The type depends on the
   * service type and the server itself. This method returns the Java version and primary facet of the object, use
   * {@link io.vertx.rxjava3.servicediscovery.ServiceReference#getAs} to retrieve the polyglot instance of the object or another facet..
   * @return the object to access the service
   */
  public <T> T get() { 
    T ret = (T) delegate.get();
    return ret;
  }

  /**
   * Gets the object to access the service. It can be a proxy, a client or whatever object. The type depends on the
   * service type and the server itself. This method wraps the service object into the desired type.
   * @param x the type of object
   * @return the object to access the service wrapped to the given type
   */
  public <X> X getAs(java.lang.Class<X> x) { 
    X ret = (X)TypeArg.of(x).wrap(delegate.getAs(io.vertx.lang.rxjava3.Helper.unwrap(x)));
    return ret;
  }

  /**
   * Gets the service object if already retrieved. It won't try to acquire the service object if not retrieved yet.
   * Unlike {@link io.vertx.rxjava3.servicediscovery.ServiceReference#cached}, this method return the warpped object to the desired (given) type.
   * @param x the type of object
   * @return the object, <code>null</code> if not yet retrieved
   */
  public <X> X cachedAs(java.lang.Class<X> x) { 
    X ret = (X)TypeArg.of(x).wrap(delegate.cachedAs(io.vertx.lang.rxjava3.Helper.unwrap(x)));
    return ret;
  }

  /**
   * Gets the service object if already retrieved. It won't try to acquire the service object if not retrieved yet.
   * @return the object, <code>null</code> if not yet retrieved
   */
  public <T> T cached() { 
    T ret = (T) delegate.cached();
    return ret;
  }

  /**
   * Releases the reference. Once released, the consumer must not use the reference anymore.
   * This method must be idempotent and defensive, as multiple call may happen.
   */
  public void release() { 
    delegate.release();
  }

  /**
   * Checks whether or not the service reference has the given service object.
   * @param object the service object, must not be <code>null</code>
   * @return <code>true</code> if the service reference service object is equal to the given object, <code>false</code> otherwise.
   */
  public boolean isHolding(java.lang.Object object) { 
    boolean ret = delegate.isHolding(object);
    return ret;
  }

  private io.vertx.servicediscovery.Record cached_0;
  public static ServiceReference newInstance(io.vertx.servicediscovery.ServiceReference arg) {
    return arg != null ? new ServiceReference(arg) : null;
  }

}
