/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.openapi.contract;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents a Security Scheme Object.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.openapi.contract.SecurityScheme original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.openapi.contract.SecurityScheme.class)
public class SecurityScheme implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SecurityScheme that = (SecurityScheme) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<SecurityScheme> __TYPE_ARG = new TypeArg<>(    obj -> new SecurityScheme((io.vertx.openapi.contract.SecurityScheme) obj),
    SecurityScheme::getDelegate
  );

  private final io.vertx.openapi.contract.SecurityScheme delegate;
  
  public SecurityScheme(io.vertx.openapi.contract.SecurityScheme delegate) {
    this.delegate = delegate;
  }

  public SecurityScheme(Object delegate) {
    this.delegate = (io.vertx.openapi.contract.SecurityScheme)delegate;
  }

  @Override 
  public io.vertx.openapi.contract.SecurityScheme getDelegate() {
    return delegate;
  }

  /**
   * The type of the security scheme. Valid values are "apiKey", "http", "mutualTLS", "oauth2", "openIdConnect"
   * @return 
   */
  public java.lang.String getType() { 
    java.lang.String ret = delegate.getType();
    return ret;
  }

  /**
   * The name of the header, query or cookie parameter to be used.
   * @return 
   */
  public java.lang.String getName() { 
    java.lang.String ret = delegate.getName();
    return ret;
  }

  /**
   * The location of the API key. Valid values are "query", "header" or "cookie".
   * @return 
   */
  public java.lang.String getIn() { 
    java.lang.String ret = delegate.getIn();
    return ret;
  }

  /**
   * The name of the HTTP Authorization scheme to be used in the Authorization header as defined in [RFC7235].
   * The values used SHOULD be registered in the IANA Authentication Scheme registry.
   * @return 
   */
  public java.lang.String getScheme() { 
    java.lang.String ret = delegate.getScheme();
    return ret;
  }

  /**
   * A hint to the client to identify how the bearer token is formatted.
   * Bearer tokens are usually generated by an authorization server, so this information is primarily for
   * documentation purposes.
   * @return 
   */
  public java.lang.String getBearerFormat() { 
    java.lang.String ret = delegate.getBearerFormat();
    return ret;
  }

  /**
   *  An object containing configuration information for the flow types supported.
   * @return 
   */
  public io.vertx.rxjava3.openapi.contract.OAuthFlows getFlows() { 
    io.vertx.rxjava3.openapi.contract.OAuthFlows ret = io.vertx.rxjava3.openapi.contract.OAuthFlows.newInstance((io.vertx.openapi.contract.OAuthFlows)delegate.getFlows());
    return ret;
  }

  /**
   * OpenId Connect URL to discover OAuth2 configuration values. This MUST be in the form of a URL.
   * The OpenID Connect standard requires the use of TLS.
   * @return 
   */
  public java.lang.String getOpenIdConnectUrl() { 
    java.lang.String ret = delegate.getOpenIdConnectUrl();
    return ret;
  }

  public static SecurityScheme newInstance(io.vertx.openapi.contract.SecurityScheme arg) {
    return arg != null ? new SecurityScheme(arg) : null;
  }

}
