/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.httpproxy;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 *
 * Handles the interoperability of the <b>response</b> between the <i><b>origin</b></i> and the <i><b>user agent</b></i>.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.httpproxy.ProxyResponse original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.httpproxy.ProxyResponse.class)
public class ProxyResponse implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProxyResponse that = (ProxyResponse) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ProxyResponse> __TYPE_ARG = new TypeArg<>(    obj -> new ProxyResponse((io.vertx.httpproxy.ProxyResponse) obj),
    ProxyResponse::getDelegate
  );

  private final io.vertx.httpproxy.ProxyResponse delegate;
  
  public ProxyResponse(io.vertx.httpproxy.ProxyResponse delegate) {
    this.delegate = delegate;
  }

  public ProxyResponse(Object delegate) {
    this.delegate = (io.vertx.httpproxy.ProxyResponse)delegate;
  }

  @Override 
  public io.vertx.httpproxy.ProxyResponse getDelegate() {
    return delegate;
  }


  /**
   *
   * Return the corresponding <code>ProxyRequest</code>.
   * @return the proxy request
   */
  public io.vertx.rxjava3.httpproxy.ProxyRequest request() { 
    io.vertx.rxjava3.httpproxy.ProxyRequest ret = io.vertx.rxjava3.httpproxy.ProxyRequest.newInstance((io.vertx.httpproxy.ProxyRequest)delegate.request());
    return ret;
  }

  /**
   * Get the status code.
   * @return the status code to be sent to the <i><b>user agent</b></i>
   */
  public int getStatusCode() { 
    int ret = delegate.getStatusCode();
    return ret;
  }

  /**
   * Set the status code to be sent to the <i><b>user agent</b></i>.
   *
   * <p> The initial value is the proxied response status code.
   * @param sc the status code
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.httpproxy.ProxyResponse setStatusCode(int sc) { 
    delegate.setStatusCode(sc);
    return this;
  }

  /**
   * Get the status message.
   * @return the status message to be sent to the <i><b>user agent</b></i>
   */
  public java.lang.String getStatusMessage() { 
    java.lang.String ret = delegate.getStatusMessage();
    return ret;
  }

  /**
   * Set the status message to be sent to the <i><b>user agent</b></i>.
   *
   * <p> The initial value is the proxied response status message.
   * @param statusMessage the status message
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.httpproxy.ProxyResponse setStatusMessage(java.lang.String statusMessage) { 
    delegate.setStatusMessage(statusMessage);
    return this;
  }

  /**
   * @return the headers that will be sent to the <i><b>user agent</b></i>, the returned headers can be modified. The headers map is populated with the proxied response headers
   */
  public io.vertx.rxjava3.core.MultiMap headers() { 
    io.vertx.rxjava3.core.MultiMap ret = io.vertx.rxjava3.core.MultiMap.newInstance((io.vertx.core.MultiMap)delegate.headers());
    return ret;
  }

  /**
   * Get the body of the response.
   * @return the response body to be sent to the <i><b>user agent</b></i>
   */
  public io.vertx.rxjava3.httpproxy.Body getBody() { 
    io.vertx.rxjava3.httpproxy.Body ret = io.vertx.rxjava3.httpproxy.Body.newInstance((io.vertx.httpproxy.Body)delegate.getBody());
    return ret;
  }

  /**
   * Set the request body to be sent to the <i><b>user agent</b></i>.
   *
   * <p>The initial request body value is the proxied response body.
   * @param body the new body
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.httpproxy.ProxyResponse setBody(io.vertx.rxjava3.httpproxy.Body body) { 
    delegate.setBody(body.getDelegate());
    return this;
  }

  public boolean publicCacheControl() { 
    boolean ret = delegate.publicCacheControl();
    return ret;
  }

  public long maxAge() { 
    long ret = delegate.maxAge();
    return ret;
  }

  /**
   * @return the <code>etag</code> sent by the <i><b>origin</b></i> response
   */
  public java.lang.String etag() { 
    java.lang.String ret = delegate.etag();
    return ret;
  }

  /**
   * Send the proxies response to the <i><b>user agent</b></i>.
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable send() { 
    io.reactivex.rxjava3.core.Completable ret = rxSend();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Send the proxies response to the <i><b>user agent</b></i>.
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxSend() { 
    return AsyncResultCompletable.toCompletable(delegate.send());
  }

  /**
   * Release the proxy response.
   *
   * <p> The proxied response is resumed, no HTTP response is sent to the <i><b>user-agent</b></i>
   * @return 
   */
  public io.vertx.rxjava3.httpproxy.ProxyResponse release() { 
    delegate.release();
    return this;
  }

  public static ProxyResponse newInstance(io.vertx.httpproxy.ProxyResponse arg) {
    return arg != null ? new ProxyResponse(arg) : null;
  }

}
