/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.web.handler;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * The X-Frame-Options HTTP response header can be used to indicate whether or not a browser should be allowed to render
 * a page in a <code><frame></code>, <code><iframe></code>, <code><embed></code> or <code><object></code>. Sites can use this to avoid
 * click-jacking attacks, by ensuring that their content is not embedded into other sites.
 *
 * The added security is provided only if the user accessing the document is using a browser that supports
 * <code>X-Frame-Options</code>.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.XFrameHandler original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.XFrameHandler.class)
public class XFrameHandler implements RxDelegate, io.vertx.rxjava3.ext.web.handler.SecurityPolicyHandler, Handler<io.vertx.rxjava3.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    XFrameHandler that = (XFrameHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<XFrameHandler> __TYPE_ARG = new TypeArg<>(    obj -> new XFrameHandler((io.vertx.ext.web.handler.XFrameHandler) obj),
    XFrameHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.XFrameHandler delegate;
  
  public XFrameHandler(io.vertx.ext.web.handler.XFrameHandler delegate) {
    this.delegate = delegate;
  }

  public XFrameHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.XFrameHandler)delegate;
  }

  @Override 
  public io.vertx.ext.web.handler.XFrameHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.rxjava3.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Creates a new handler that will add the <code>X-FRAME-OPTIONS</code> header to the current response.
   * @param action a string value either <code>DENY</code> or <code>SAMEORIGIN</code>.
   * @return the handler
   */
  public static io.vertx.rxjava3.ext.web.handler.XFrameHandler create(java.lang.String action) { 
    io.vertx.rxjava3.ext.web.handler.XFrameHandler ret = io.vertx.rxjava3.ext.web.handler.XFrameHandler.newInstance((io.vertx.ext.web.handler.XFrameHandler)io.vertx.ext.web.handler.XFrameHandler.create(action));
    return ret;
  }

  /**
   * The page cannot be displayed in a frame, regardless of the site attempting to do so.
   */
  public static final java.lang.String DENY = io.vertx.ext.web.handler.XFrameHandler.DENY;
  /**
   * The page can only be displayed in a frame on the same origin as the page itself. The spec leaves it up to browser
   * vendors to decide whether this option applies to the top level, the parent, or the whole chain, although it is
   * argued that the option is not very useful unless all ancestors are also in the same origin.
   */
  public static final java.lang.String SAMEORIGIN = io.vertx.ext.web.handler.XFrameHandler.SAMEORIGIN;
  public static XFrameHandler newInstance(io.vertx.ext.web.handler.XFrameHandler arg) {
    return arg != null ? new XFrameHandler(arg) : null;
  }

}
