/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.auth.mongo;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An extension of AuthProvider which is using  as store
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.mongo.MongoAuthorization original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.mongo.MongoAuthorization.class)
public class MongoAuthorization extends io.vertx.rxjava3.ext.auth.authorization.AuthorizationProvider implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MongoAuthorization that = (MongoAuthorization) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MongoAuthorization> __TYPE_ARG = new TypeArg<>(    obj -> new MongoAuthorization((io.vertx.ext.auth.mongo.MongoAuthorization) obj),
    MongoAuthorization::getDelegate
  );

  private final io.vertx.ext.auth.mongo.MongoAuthorization delegate;
  
  public MongoAuthorization(io.vertx.ext.auth.mongo.MongoAuthorization delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public MongoAuthorization(Object delegate) {
    super((io.vertx.ext.auth.mongo.MongoAuthorization)delegate);
    this.delegate = (io.vertx.ext.auth.mongo.MongoAuthorization)delegate;
  }

  @Override 
  public io.vertx.ext.auth.mongo.MongoAuthorization getDelegate() {
    return delegate;
  }

  /**
   * Creates an instance of MongoAuthorization by using the given  and configuration object.
   * @param providerId the provider ID to differentiate from others
   * @param mongoClient an instance of  to be used for data storage and retrival
   * @param options the configuration object for the current instance.
   * @return the created instance of {@link io.vertx.rxjava3.ext.auth.mongo.MongoAuthorization}
   */
  public static io.vertx.rxjava3.ext.auth.mongo.MongoAuthorization create(java.lang.String providerId, io.vertx.rxjava3.ext.mongo.MongoClient mongoClient, io.vertx.ext.auth.mongo.MongoAuthorizationOptions options) { 
    io.vertx.rxjava3.ext.auth.mongo.MongoAuthorization ret = io.vertx.rxjava3.ext.auth.mongo.MongoAuthorization.newInstance((io.vertx.ext.auth.mongo.MongoAuthorization)io.vertx.ext.auth.mongo.MongoAuthorization.create(providerId, mongoClient.getDelegate(), options));
    return ret;
  }

  /**
   * The default name of the collection to be used
   */
  public static final java.lang.String DEFAULT_COLLECTION_NAME = io.vertx.ext.auth.mongo.MongoAuthorization.DEFAULT_COLLECTION_NAME;
  /**
   * The default name of the property for the username, like it is stored in mongodb
   */
  public static final java.lang.String DEFAULT_USERNAME_FIELD = io.vertx.ext.auth.mongo.MongoAuthorization.DEFAULT_USERNAME_FIELD;
  /**
   * The default name of the property for the roles, like it is stored in mongodb. Roles are expected to be saved as
   * JsonArray
   */
  public static final java.lang.String DEFAULT_ROLE_FIELD = io.vertx.ext.auth.mongo.MongoAuthorization.DEFAULT_ROLE_FIELD;
  /**
   * The default name of the property for the permissions, like it is stored in mongodb. Permissions are expected to be
   * saved as JsonArray
   */
  public static final java.lang.String DEFAULT_PERMISSION_FIELD = io.vertx.ext.auth.mongo.MongoAuthorization.DEFAULT_PERMISSION_FIELD;
  public static MongoAuthorization newInstance(io.vertx.ext.auth.mongo.MongoAuthorization arg) {
    return arg != null ? new MongoAuthorization(arg) : null;
  }

}
