/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.core.http;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Observable;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.streams.ReadStream;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rxjava3.Helper;
import io.vertx.rxjava3.CompletableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import io.vertx.rxjava3.core.MultiMap;
import io.vertx.rxjava3.core.http.WebSocketBase;
import io.vertx.rxjava3.core.http.WebSocketFrame;
import io.vertx.rxjava3.core.net.SocketAddress;
import io.vertx.rxjava3.core.streams.Pipe;
import io.vertx.rxjava3.core.streams.WriteStream;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import java.util.function.Function;
import javax.net.ssl.SSLSession;

class WebSocketBaseImpl
implements WebSocketBase {
    private final io.vertx.core.http.WebSocketBase delegate;
    private Observable<io.vertx.rxjava3.core.buffer.Buffer> observable;
    private Flowable<io.vertx.rxjava3.core.buffer.Buffer> flowable;
    private WriteStreamObserver<io.vertx.rxjava3.core.buffer.Buffer> observer;
    private WriteStreamSubscriber<io.vertx.rxjava3.core.buffer.Buffer> subscriber;
    private static final TypeArg<io.vertx.rxjava3.core.buffer.Buffer> TYPE_ARG_0 = new TypeArg(o1 -> io.vertx.rxjava3.core.buffer.Buffer.newInstance((Buffer)o1), o1 -> o1.getDelegate());
    private SocketAddress cached_0;
    private SocketAddress cached_1;

    public WebSocketBaseImpl(io.vertx.core.http.WebSocketBase delegate) {
        this.delegate = delegate;
    }

    public WebSocketBaseImpl(Object delegate) {
        this.delegate = (io.vertx.core.http.WebSocketBase)delegate;
    }

    @Override
    public io.vertx.core.http.WebSocketBase getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<io.vertx.rxjava3.core.buffer.Buffer> toObservable() {
        if (this.observable == null) {
            Function<Buffer, io.vertx.rxjava3.core.buffer.Buffer> conv = io.vertx.rxjava3.core.buffer.Buffer::newInstance;
            this.observable = ObservableHelper.toObservable((ReadStream)this.delegate, conv);
        }
        return this.observable;
    }

    @Override
    public synchronized Flowable<io.vertx.rxjava3.core.buffer.Buffer> toFlowable() {
        if (this.flowable == null) {
            Function<Buffer, io.vertx.rxjava3.core.buffer.Buffer> conv = io.vertx.rxjava3.core.buffer.Buffer::newInstance;
            this.flowable = FlowableHelper.toFlowable((ReadStream)this.delegate, conv);
        }
        return this.flowable;
    }

    @Override
    public synchronized WriteStreamObserver<io.vertx.rxjava3.core.buffer.Buffer> toObserver() {
        if (this.observer == null) {
            Function<io.vertx.rxjava3.core.buffer.Buffer, Buffer> conv = io.vertx.rxjava3.core.buffer.Buffer::getDelegate;
            this.observer = RxHelper.toObserver((io.vertx.core.streams.WriteStream)this.getDelegate(), conv);
        }
        return this.observer;
    }

    @Override
    public synchronized WriteStreamSubscriber<io.vertx.rxjava3.core.buffer.Buffer> toSubscriber() {
        if (this.subscriber == null) {
            Function<io.vertx.rxjava3.core.buffer.Buffer, Buffer> conv = io.vertx.rxjava3.core.buffer.Buffer::getDelegate;
            this.subscriber = RxHelper.toSubscriber((io.vertx.core.streams.WriteStream)this.getDelegate(), conv);
        }
        return this.subscriber;
    }

    @Override
    public Pipe<io.vertx.rxjava3.core.buffer.Buffer> pipe() {
        Pipe<io.vertx.rxjava3.core.buffer.Buffer> ret = Pipe.newInstance(this.delegate.pipe(), TYPE_ARG_0);
        return ret;
    }

    @Override
    public Completable pipeTo(WriteStream<io.vertx.rxjava3.core.buffer.Buffer> dst) {
        Completable ret = this.rxPipeTo(dst);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxPipeTo(WriteStream<io.vertx.rxjava3.core.buffer.Buffer> dst) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.pipeTo(dst.getDelegate(), handler));
    }

    @Override
    public Completable write(io.vertx.rxjava3.core.buffer.Buffer data) {
        Completable ret = this.rxWrite(data);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxWrite(io.vertx.rxjava3.core.buffer.Buffer data) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.write((Object)data.getDelegate(), handler));
    }

    @Override
    public Completable end(io.vertx.rxjava3.core.buffer.Buffer data) {
        Completable ret = this.rxEnd(data);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxEnd(io.vertx.rxjava3.core.buffer.Buffer data) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.end((Object)data.getDelegate(), handler));
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public WebSocketBase exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    @Override
    public WebSocketBase handler(Handler<io.vertx.rxjava3.core.buffer.Buffer> handler) {
        this.delegate.handler(Helper.convertHandler(handler, event -> io.vertx.rxjava3.core.buffer.Buffer.newInstance(event)));
        return this;
    }

    @Override
    public WebSocketBase pause() {
        this.delegate.pause();
        return this;
    }

    @Override
    public WebSocketBase resume() {
        this.delegate.resume();
        return this;
    }

    @Override
    public WebSocketBase fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    @Override
    public WebSocketBase endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    @Override
    public WebSocketBase setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    @Override
    public WebSocketBase drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    @Override
    public String binaryHandlerID() {
        String ret = this.delegate.binaryHandlerID();
        return ret;
    }

    @Override
    public String textHandlerID() {
        String ret = this.delegate.textHandlerID();
        return ret;
    }

    @Override
    public String subProtocol() {
        String ret = this.delegate.subProtocol();
        return ret;
    }

    @Override
    public Short closeStatusCode() {
        Short ret = this.delegate.closeStatusCode();
        return ret;
    }

    @Override
    public String closeReason() {
        String ret = this.delegate.closeReason();
        return ret;
    }

    @Override
    public MultiMap headers() {
        MultiMap ret = MultiMap.newInstance(this.delegate.headers());
        return ret;
    }

    @Override
    public Completable writeFrame(WebSocketFrame frame) {
        Completable ret = this.rxWriteFrame(frame);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxWriteFrame(WebSocketFrame frame) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.writeFrame(frame.getDelegate(), handler));
    }

    @Override
    public Completable writeFinalTextFrame(String text) {
        Completable ret = this.rxWriteFinalTextFrame(text);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxWriteFinalTextFrame(String text) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.writeFinalTextFrame(text, handler));
    }

    @Override
    public Completable writeFinalBinaryFrame(io.vertx.rxjava3.core.buffer.Buffer data) {
        Completable ret = this.rxWriteFinalBinaryFrame(data);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxWriteFinalBinaryFrame(io.vertx.rxjava3.core.buffer.Buffer data) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.writeFinalBinaryFrame(data.getDelegate(), handler));
    }

    @Override
    public Completable writeBinaryMessage(io.vertx.rxjava3.core.buffer.Buffer data) {
        Completable ret = this.rxWriteBinaryMessage(data);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxWriteBinaryMessage(io.vertx.rxjava3.core.buffer.Buffer data) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.writeBinaryMessage(data.getDelegate(), handler));
    }

    @Override
    public Completable writeTextMessage(String text) {
        Completable ret = this.rxWriteTextMessage(text);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxWriteTextMessage(String text) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.writeTextMessage(text, handler));
    }

    @Override
    public Completable writePing(io.vertx.rxjava3.core.buffer.Buffer data) {
        Completable ret = this.rxWritePing(data);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxWritePing(io.vertx.rxjava3.core.buffer.Buffer data) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.writePing(data.getDelegate(), handler));
    }

    @Override
    public Completable writePong(io.vertx.rxjava3.core.buffer.Buffer data) {
        Completable ret = this.rxWritePong(data);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxWritePong(io.vertx.rxjava3.core.buffer.Buffer data) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.writePong(data.getDelegate(), handler));
    }

    @Override
    public WebSocketBase closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    @Override
    public WebSocketBase frameHandler(Handler<WebSocketFrame> handler) {
        this.delegate.frameHandler(Helper.convertHandler(handler, event -> WebSocketFrame.newInstance(event)));
        return this;
    }

    @Override
    public WebSocketBase textMessageHandler(Handler<String> handler) {
        this.delegate.textMessageHandler(handler);
        return this;
    }

    @Override
    public WebSocketBase binaryMessageHandler(Handler<io.vertx.rxjava3.core.buffer.Buffer> handler) {
        this.delegate.binaryMessageHandler(Helper.convertHandler(handler, event -> io.vertx.rxjava3.core.buffer.Buffer.newInstance(event)));
        return this;
    }

    @Override
    public WebSocketBase pongHandler(Handler<io.vertx.rxjava3.core.buffer.Buffer> handler) {
        this.delegate.pongHandler(Helper.convertHandler(handler, event -> io.vertx.rxjava3.core.buffer.Buffer.newInstance(event)));
        return this;
    }

    @Override
    public Completable end() {
        Completable ret = this.rxEnd();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxEnd() {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.end(handler));
    }

    @Override
    public Completable close() {
        Completable ret = this.rxClose();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.close(handler));
    }

    @Override
    public Completable close(short statusCode) {
        Completable ret = this.rxClose(statusCode);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxClose(short statusCode) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.close(statusCode, handler));
    }

    @Override
    public Completable close(short statusCode, String reason) {
        Completable ret = this.rxClose(statusCode, reason);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxClose(short statusCode, String reason) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.close(statusCode, reason, handler));
    }

    @Override
    public SocketAddress remoteAddress() {
        SocketAddress ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = SocketAddress.newInstance(this.delegate.remoteAddress());
        return ret;
    }

    @Override
    public SocketAddress localAddress() {
        SocketAddress ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = SocketAddress.newInstance(this.delegate.localAddress());
        return ret;
    }

    @Override
    public boolean isSsl() {
        boolean ret = this.delegate.isSsl();
        return ret;
    }

    @Override
    public boolean isClosed() {
        boolean ret = this.delegate.isClosed();
        return ret;
    }

    public SSLSession sslSession() {
        SSLSession ret = this.delegate.sslSession();
        return ret;
    }
}

