/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.core.file;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Single;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.lang.rx.DelegatingHandler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rxjava3.CompletableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.SingleHelper;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import io.vertx.rxjava3.core.file.AsyncFileLock;
import io.vertx.rxjava3.core.streams.Pipe;
import io.vertx.rxjava3.core.streams.ReadStream;
import io.vertx.rxjava3.core.streams.WriteStream;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import java.util.function.Function;

@RxGen(value=io.vertx.core.file.AsyncFile.class)
public class AsyncFile
implements ReadStream<io.vertx.rxjava3.core.buffer.Buffer>,
WriteStream<io.vertx.rxjava3.core.buffer.Buffer> {
    public static final TypeArg<AsyncFile> __TYPE_ARG = new TypeArg(obj -> new AsyncFile((io.vertx.core.file.AsyncFile)obj), AsyncFile::getDelegate);
    private final io.vertx.core.file.AsyncFile delegate;
    private Observable<io.vertx.rxjava3.core.buffer.Buffer> observable;
    private Flowable<io.vertx.rxjava3.core.buffer.Buffer> flowable;
    private WriteStreamObserver<io.vertx.rxjava3.core.buffer.Buffer> observer;
    private WriteStreamSubscriber<io.vertx.rxjava3.core.buffer.Buffer> subscriber;
    private static final TypeArg<io.vertx.rxjava3.core.buffer.Buffer> TYPE_ARG_0 = new TypeArg(o1 -> io.vertx.rxjava3.core.buffer.Buffer.newInstance((Buffer)o1), o1 -> o1.getDelegate());

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AsyncFile that = (AsyncFile)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public AsyncFile(io.vertx.core.file.AsyncFile delegate) {
        this.delegate = delegate;
    }

    public AsyncFile(Object delegate) {
        this.delegate = (io.vertx.core.file.AsyncFile)delegate;
    }

    public io.vertx.core.file.AsyncFile getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<io.vertx.rxjava3.core.buffer.Buffer> toObservable() {
        if (this.observable == null) {
            Function<Buffer, io.vertx.rxjava3.core.buffer.Buffer> conv = io.vertx.rxjava3.core.buffer.Buffer::newInstance;
            this.observable = ObservableHelper.toObservable((io.vertx.core.streams.ReadStream)this.delegate, conv);
        }
        return this.observable;
    }

    @Override
    public synchronized Flowable<io.vertx.rxjava3.core.buffer.Buffer> toFlowable() {
        if (this.flowable == null) {
            Function<Buffer, io.vertx.rxjava3.core.buffer.Buffer> conv = io.vertx.rxjava3.core.buffer.Buffer::newInstance;
            this.flowable = FlowableHelper.toFlowable((io.vertx.core.streams.ReadStream)this.delegate, conv);
        }
        return this.flowable;
    }

    @Override
    public synchronized WriteStreamObserver<io.vertx.rxjava3.core.buffer.Buffer> toObserver() {
        if (this.observer == null) {
            Function<io.vertx.rxjava3.core.buffer.Buffer, Buffer> conv = io.vertx.rxjava3.core.buffer.Buffer::getDelegate;
            this.observer = RxHelper.toObserver((io.vertx.core.streams.WriteStream)this.getDelegate(), conv);
        }
        return this.observer;
    }

    @Override
    public synchronized WriteStreamSubscriber<io.vertx.rxjava3.core.buffer.Buffer> toSubscriber() {
        if (this.subscriber == null) {
            Function<io.vertx.rxjava3.core.buffer.Buffer, Buffer> conv = io.vertx.rxjava3.core.buffer.Buffer::getDelegate;
            this.subscriber = RxHelper.toSubscriber((io.vertx.core.streams.WriteStream)this.getDelegate(), conv);
        }
        return this.subscriber;
    }

    @Override
    public Completable write(io.vertx.rxjava3.core.buffer.Buffer data) {
        Completable ret = this.rxWrite(data);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxWrite(io.vertx.rxjava3.core.buffer.Buffer data) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.write((Object)data.getDelegate(), handler));
    }

    @Override
    public Completable end() {
        Completable ret = this.rxEnd();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxEnd() {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.end(handler));
    }

    @Override
    public Completable end(io.vertx.rxjava3.core.buffer.Buffer data) {
        Completable ret = this.rxEnd(data);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxEnd(io.vertx.rxjava3.core.buffer.Buffer data) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.end((Object)data.getDelegate(), handler));
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public Pipe<io.vertx.rxjava3.core.buffer.Buffer> pipe() {
        Pipe<io.vertx.rxjava3.core.buffer.Buffer> ret = Pipe.newInstance(this.delegate.pipe(), TYPE_ARG_0);
        return ret;
    }

    @Override
    public Completable pipeTo(WriteStream<io.vertx.rxjava3.core.buffer.Buffer> dst) {
        Completable ret = this.rxPipeTo(dst);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxPipeTo(WriteStream<io.vertx.rxjava3.core.buffer.Buffer> dst) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.pipeTo(dst.getDelegate(), handler));
    }

    public AsyncFile handler(Handler<io.vertx.rxjava3.core.buffer.Buffer> handler) {
        this.delegate.handler((Handler)new DelegatingHandler(handler, event -> io.vertx.rxjava3.core.buffer.Buffer.newInstance(event)));
        return this;
    }

    public AsyncFile pause() {
        this.delegate.pause();
        return this;
    }

    public AsyncFile resume() {
        this.delegate.resume();
        return this;
    }

    public AsyncFile endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public AsyncFile setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    public AsyncFile drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    @Override
    public AsyncFile exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public AsyncFile fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    public Completable close() {
        Completable ret = this.rxClose();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.close(handler));
    }

    public Completable write(io.vertx.rxjava3.core.buffer.Buffer buffer, long position) {
        Completable ret = this.rxWrite(buffer, position);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxWrite(io.vertx.rxjava3.core.buffer.Buffer buffer, long position) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.write(buffer.getDelegate(), position, handler));
    }

    public Single<io.vertx.rxjava3.core.buffer.Buffer> read(io.vertx.rxjava3.core.buffer.Buffer buffer, int offset, long position, int length) {
        Single ret = this.rxRead(buffer, offset, position, length);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<io.vertx.rxjava3.core.buffer.Buffer> rxRead(io.vertx.rxjava3.core.buffer.Buffer buffer, int offset, long position, int length) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.read(buffer.getDelegate(), offset, position, length, (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.core.buffer.Buffer.newInstance(event)))));
    }

    public Completable flush() {
        Completable ret = this.rxFlush();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxFlush() {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.flush(handler));
    }

    public AsyncFile setReadPos(long readPos) {
        this.delegate.setReadPos(readPos);
        return this;
    }

    public AsyncFile setReadLength(long readLength) {
        this.delegate.setReadLength(readLength);
        return this;
    }

    public long getReadLength() {
        long ret = this.delegate.getReadLength();
        return ret;
    }

    public AsyncFile setWritePos(long writePos) {
        this.delegate.setWritePos(writePos);
        return this;
    }

    public long getWritePos() {
        long ret = this.delegate.getWritePos();
        return ret;
    }

    public AsyncFile setReadBufferSize(int readBufferSize) {
        this.delegate.setReadBufferSize(readBufferSize);
        return this;
    }

    public long sizeBlocking() {
        long ret = this.delegate.sizeBlocking();
        return ret;
    }

    public Single<Long> size() {
        Single ret = this.rxSize();
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Long> rxSize() {
        return AsyncResultSingle.toSingle(handler -> this.delegate.size(handler));
    }

    public AsyncFileLock tryLock() {
        AsyncFileLock ret = AsyncFileLock.newInstance(this.delegate.tryLock());
        return ret;
    }

    public AsyncFileLock tryLock(long position, long size, boolean shared) {
        AsyncFileLock ret = AsyncFileLock.newInstance(this.delegate.tryLock(position, size, shared));
        return ret;
    }

    public Single<AsyncFileLock> lock() {
        Single ret = this.rxLock();
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<AsyncFileLock> rxLock() {
        return AsyncResultSingle.toSingle(handler -> this.delegate.lock((Handler)new DelegatingHandler(handler, ar -> ar.map(event -> AsyncFileLock.newInstance(event)))));
    }

    public Single<AsyncFileLock> lock(long position, long size, boolean shared) {
        Single ret = this.rxLock(position, size, shared);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<AsyncFileLock> rxLock(long position, long size, boolean shared) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.lock(position, size, shared, (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> AsyncFileLock.newInstance(event)))));
    }

    public static AsyncFile newInstance(io.vertx.core.file.AsyncFile arg) {
        return arg != null ? new AsyncFile(arg) : null;
    }
}

