/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.core.buffer;

import io.netty.buffer.ByteBuf;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.impl.ClusterSerializable;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

@RxGen(value=io.vertx.core.buffer.Buffer.class)
public class Buffer
implements ClusterSerializable {
    public static final TypeArg<Buffer> __TYPE_ARG = new TypeArg(obj -> new Buffer((io.vertx.core.buffer.Buffer)obj), Buffer::getDelegate);
    private final io.vertx.core.buffer.Buffer delegate;

    public void writeToBuffer(io.vertx.core.buffer.Buffer buffer) {
        this.delegate.writeToBuffer(buffer);
    }

    public int readFromBuffer(int pos, io.vertx.core.buffer.Buffer buffer) {
        return this.delegate.readFromBuffer(pos, buffer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Buffer that = (Buffer)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public Buffer(io.vertx.core.buffer.Buffer delegate) {
        this.delegate = delegate;
    }

    public Buffer(Object delegate) {
        this.delegate = (io.vertx.core.buffer.Buffer)delegate;
    }

    public io.vertx.core.buffer.Buffer getDelegate() {
        return this.delegate;
    }

    public static Buffer buffer() {
        Buffer ret = Buffer.newInstance(io.vertx.core.buffer.Buffer.buffer());
        return ret;
    }

    public static Buffer buffer(int initialSizeHint) {
        Buffer ret = Buffer.newInstance(io.vertx.core.buffer.Buffer.buffer((int)initialSizeHint));
        return ret;
    }

    public static Buffer buffer(String string) {
        Buffer ret = Buffer.newInstance(io.vertx.core.buffer.Buffer.buffer((String)string));
        return ret;
    }

    public static Buffer buffer(String string, String enc) {
        Buffer ret = Buffer.newInstance(io.vertx.core.buffer.Buffer.buffer((String)string, (String)enc));
        return ret;
    }

    public String toString() {
        String ret = this.delegate.toString();
        return ret;
    }

    public String toString(String enc) {
        String ret = this.delegate.toString(enc);
        return ret;
    }

    public JsonObject toJsonObject() {
        JsonObject ret = this.delegate.toJsonObject();
        return ret;
    }

    public JsonArray toJsonArray() {
        JsonArray ret = this.delegate.toJsonArray();
        return ret;
    }

    public Object toJsonValue() {
        Object ret = this.delegate.toJsonValue();
        return ret;
    }

    @Deprecated
    public Object toJson() {
        Object ret = this.delegate.toJson();
        return ret;
    }

    public byte getByte(int pos) {
        byte ret = this.delegate.getByte(pos);
        return ret;
    }

    public short getUnsignedByte(int pos) {
        short ret = this.delegate.getUnsignedByte(pos);
        return ret;
    }

    public int getInt(int pos) {
        int ret = this.delegate.getInt(pos);
        return ret;
    }

    public int getIntLE(int pos) {
        int ret = this.delegate.getIntLE(pos);
        return ret;
    }

    public long getUnsignedInt(int pos) {
        long ret = this.delegate.getUnsignedInt(pos);
        return ret;
    }

    public long getUnsignedIntLE(int pos) {
        long ret = this.delegate.getUnsignedIntLE(pos);
        return ret;
    }

    public long getLong(int pos) {
        long ret = this.delegate.getLong(pos);
        return ret;
    }

    public long getLongLE(int pos) {
        long ret = this.delegate.getLongLE(pos);
        return ret;
    }

    public double getDouble(int pos) {
        double ret = this.delegate.getDouble(pos);
        return ret;
    }

    public float getFloat(int pos) {
        float ret = this.delegate.getFloat(pos);
        return ret;
    }

    public short getShort(int pos) {
        short ret = this.delegate.getShort(pos);
        return ret;
    }

    public short getShortLE(int pos) {
        short ret = this.delegate.getShortLE(pos);
        return ret;
    }

    public int getUnsignedShort(int pos) {
        int ret = this.delegate.getUnsignedShort(pos);
        return ret;
    }

    public int getUnsignedShortLE(int pos) {
        int ret = this.delegate.getUnsignedShortLE(pos);
        return ret;
    }

    public int getMedium(int pos) {
        int ret = this.delegate.getMedium(pos);
        return ret;
    }

    public int getMediumLE(int pos) {
        int ret = this.delegate.getMediumLE(pos);
        return ret;
    }

    public int getUnsignedMedium(int pos) {
        int ret = this.delegate.getUnsignedMedium(pos);
        return ret;
    }

    public int getUnsignedMediumLE(int pos) {
        int ret = this.delegate.getUnsignedMediumLE(pos);
        return ret;
    }

    public Buffer getBuffer(int start, int end) {
        Buffer ret = Buffer.newInstance(this.delegate.getBuffer(start, end));
        return ret;
    }

    public String getString(int start, int end, String enc) {
        String ret = this.delegate.getString(start, end, enc);
        return ret;
    }

    public String getString(int start, int end) {
        String ret = this.delegate.getString(start, end);
        return ret;
    }

    public Buffer appendBuffer(Buffer buff) {
        this.delegate.appendBuffer(buff.getDelegate());
        return this;
    }

    public Buffer appendBuffer(Buffer buff, int offset, int len) {
        this.delegate.appendBuffer(buff.getDelegate(), offset, len);
        return this;
    }

    public Buffer appendByte(byte b) {
        this.delegate.appendByte(b);
        return this;
    }

    public Buffer appendUnsignedByte(short b) {
        this.delegate.appendUnsignedByte(b);
        return this;
    }

    public Buffer appendInt(int i) {
        this.delegate.appendInt(i);
        return this;
    }

    public Buffer appendIntLE(int i) {
        this.delegate.appendIntLE(i);
        return this;
    }

    public Buffer appendUnsignedInt(long i) {
        this.delegate.appendUnsignedInt(i);
        return this;
    }

    public Buffer appendUnsignedIntLE(long i) {
        this.delegate.appendUnsignedIntLE(i);
        return this;
    }

    public Buffer appendMedium(int i) {
        this.delegate.appendMedium(i);
        return this;
    }

    public Buffer appendMediumLE(int i) {
        this.delegate.appendMediumLE(i);
        return this;
    }

    public Buffer appendLong(long l) {
        this.delegate.appendLong(l);
        return this;
    }

    public Buffer appendLongLE(long l) {
        this.delegate.appendLongLE(l);
        return this;
    }

    public Buffer appendShort(short s) {
        this.delegate.appendShort(s);
        return this;
    }

    public Buffer appendShortLE(short s) {
        this.delegate.appendShortLE(s);
        return this;
    }

    public Buffer appendUnsignedShort(int s) {
        this.delegate.appendUnsignedShort(s);
        return this;
    }

    public Buffer appendUnsignedShortLE(int s) {
        this.delegate.appendUnsignedShortLE(s);
        return this;
    }

    public Buffer appendFloat(float f) {
        this.delegate.appendFloat(f);
        return this;
    }

    public Buffer appendDouble(double d) {
        this.delegate.appendDouble(d);
        return this;
    }

    public Buffer appendString(String str, String enc) {
        this.delegate.appendString(str, enc);
        return this;
    }

    public Buffer appendString(String str) {
        this.delegate.appendString(str);
        return this;
    }

    public Buffer setByte(int pos, byte b) {
        this.delegate.setByte(pos, b);
        return this;
    }

    public Buffer setUnsignedByte(int pos, short b) {
        this.delegate.setUnsignedByte(pos, b);
        return this;
    }

    public Buffer setInt(int pos, int i) {
        this.delegate.setInt(pos, i);
        return this;
    }

    public Buffer setIntLE(int pos, int i) {
        this.delegate.setIntLE(pos, i);
        return this;
    }

    public Buffer setUnsignedInt(int pos, long i) {
        this.delegate.setUnsignedInt(pos, i);
        return this;
    }

    public Buffer setUnsignedIntLE(int pos, long i) {
        this.delegate.setUnsignedIntLE(pos, i);
        return this;
    }

    public Buffer setMedium(int pos, int i) {
        this.delegate.setMedium(pos, i);
        return this;
    }

    public Buffer setMediumLE(int pos, int i) {
        this.delegate.setMediumLE(pos, i);
        return this;
    }

    public Buffer setLong(int pos, long l) {
        this.delegate.setLong(pos, l);
        return this;
    }

    public Buffer setLongLE(int pos, long l) {
        this.delegate.setLongLE(pos, l);
        return this;
    }

    public Buffer setDouble(int pos, double d) {
        this.delegate.setDouble(pos, d);
        return this;
    }

    public Buffer setFloat(int pos, float f) {
        this.delegate.setFloat(pos, f);
        return this;
    }

    public Buffer setShort(int pos, short s) {
        this.delegate.setShort(pos, s);
        return this;
    }

    public Buffer setShortLE(int pos, short s) {
        this.delegate.setShortLE(pos, s);
        return this;
    }

    public Buffer setUnsignedShort(int pos, int s) {
        this.delegate.setUnsignedShort(pos, s);
        return this;
    }

    public Buffer setUnsignedShortLE(int pos, int s) {
        this.delegate.setUnsignedShortLE(pos, s);
        return this;
    }

    public Buffer setBuffer(int pos, Buffer b) {
        this.delegate.setBuffer(pos, b.getDelegate());
        return this;
    }

    public Buffer setBuffer(int pos, Buffer b, int offset, int len) {
        this.delegate.setBuffer(pos, b.getDelegate(), offset, len);
        return this;
    }

    public Buffer setString(int pos, String str) {
        this.delegate.setString(pos, str);
        return this;
    }

    public Buffer setString(int pos, String str, String enc) {
        this.delegate.setString(pos, str, enc);
        return this;
    }

    public int length() {
        int ret = this.delegate.length();
        return ret;
    }

    public Buffer copy() {
        Buffer ret = Buffer.newInstance(this.delegate.copy());
        return ret;
    }

    public Buffer slice() {
        Buffer ret = Buffer.newInstance(this.delegate.slice());
        return ret;
    }

    public Buffer slice(int start, int end) {
        Buffer ret = Buffer.newInstance(this.delegate.slice(start, end));
        return ret;
    }

    public static Buffer buffer(byte[] bytes) {
        Buffer ret = Buffer.newInstance(io.vertx.core.buffer.Buffer.buffer((byte[])bytes));
        return ret;
    }

    @Deprecated
    public static Buffer buffer(ByteBuf byteBuf) {
        Buffer ret = Buffer.newInstance(io.vertx.core.buffer.Buffer.buffer((ByteBuf)byteBuf));
        return ret;
    }

    public String toString(Charset enc) {
        String ret = this.delegate.toString(enc);
        return ret;
    }

    public byte[] getBytes() {
        byte[] ret = this.delegate.getBytes();
        return ret;
    }

    public byte[] getBytes(int start, int end) {
        byte[] ret = this.delegate.getBytes(start, end);
        return ret;
    }

    public Buffer getBytes(byte[] dst) {
        this.delegate.getBytes(dst);
        return this;
    }

    public Buffer getBytes(byte[] dst, int dstIndex) {
        this.delegate.getBytes(dst, dstIndex);
        return this;
    }

    public Buffer getBytes(int start, int end, byte[] dst) {
        this.delegate.getBytes(start, end, dst);
        return this;
    }

    public Buffer getBytes(int start, int end, byte[] dst, int dstIndex) {
        this.delegate.getBytes(start, end, dst, dstIndex);
        return this;
    }

    public Buffer appendBytes(byte[] bytes) {
        this.delegate.appendBytes(bytes);
        return this;
    }

    public Buffer appendBytes(byte[] bytes, int offset, int len) {
        this.delegate.appendBytes(bytes, offset, len);
        return this;
    }

    public Buffer setBytes(int pos, ByteBuffer b) {
        this.delegate.setBytes(pos, b);
        return this;
    }

    public Buffer setBytes(int pos, byte[] b) {
        this.delegate.setBytes(pos, b);
        return this;
    }

    public Buffer setBytes(int pos, byte[] b, int offset, int len) {
        this.delegate.setBytes(pos, b, offset, len);
        return this;
    }

    @Deprecated
    public ByteBuf getByteBuf() {
        ByteBuf ret = this.delegate.getByteBuf();
        return ret;
    }

    public static Buffer newInstance(io.vertx.core.buffer.Buffer arg) {
        return arg != null ? new Buffer(arg) : null;
    }
}

