/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.uritemplate;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A URI template that follows the <a href="https://datatracker.ietf.org/doc/html/rfc6570">rfc6570</a> level 4.
 *
 * <p> A template is immutable and thread safe, it can be safely shared between threads after its creation.
 * If you are sharing a template as a static variables, keep in mind that {@link io.vertx.rxjava3.uritemplate.UriTemplate#of} can fail and create
 * a classloading issue.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.uritemplate.UriTemplate original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.uritemplate.UriTemplate.class)
public class UriTemplate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    UriTemplate that = (UriTemplate) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<UriTemplate> __TYPE_ARG = new TypeArg<>(    obj -> new UriTemplate((io.vertx.uritemplate.UriTemplate) obj),
    UriTemplate::getDelegate
  );

  private final io.vertx.uritemplate.UriTemplate delegate;
  
  public UriTemplate(io.vertx.uritemplate.UriTemplate delegate) {
    this.delegate = delegate;
  }

  public UriTemplate(Object delegate) {
    this.delegate = (io.vertx.uritemplate.UriTemplate)delegate;
  }

  public io.vertx.uritemplate.UriTemplate getDelegate() {
    return delegate;
  }

  /**
   * Create a template from a string <code>uri</code>.
   *
   * <p> The string <code>uri</code> is validated and parsed, invalid inputs are rejected with a {@link java.lang.IllegalArgumentException}.
   * @param uri the template string
   * @return the template
   */
  public static io.vertx.rxjava3.uritemplate.UriTemplate of(java.lang.String uri) { 
    io.vertx.rxjava3.uritemplate.UriTemplate ret = io.vertx.rxjava3.uritemplate.UriTemplate.newInstance((io.vertx.uritemplate.UriTemplate)io.vertx.uritemplate.UriTemplate.of(uri));
    return ret;
  }

  /**
   * Expand this template to a string.
   * @param variables the variables
   * @return the string expansion of this template with the <code>variables</code>
   */
  public java.lang.String expandToString(io.vertx.rxjava3.uritemplate.Variables variables) { 
    java.lang.String ret = delegate.expandToString(variables.getDelegate());
    return ret;
  }

  /**
   * Expand this template to a string.
   * @param variables the variables
   * @param options the options to control template expansion
   * @return the string expansion of this template with the <code>variables</code>
   */
  public java.lang.String expandToString(io.vertx.rxjava3.uritemplate.Variables variables, io.vertx.uritemplate.ExpandOptions options) { 
    java.lang.String ret = delegate.expandToString(variables.getDelegate(), options);
    return ret;
  }

  public static UriTemplate newInstance(io.vertx.uritemplate.UriTemplate arg) {
    return arg != null ? new UriTemplate(arg) : null;
  }

}
